/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.tmptask.workqueue;

import com.bfd.crawler.tmptask.Task;
import com.bfd.crawler.tmptask.bloomfilter.BloomFilter;
import com.bfd.crawler.tmptask.workqueue.IWorkQueue;
import com.bfd.crawler.utils.DataUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.log4j.Logger;

public class WorkQueueRAM
implements IWorkQueue {
    public static String queueName = "news_queue";
    public static BloomFilter bloomFilter = new BloomFilter();
    private static Logger log = Logger.getLogger(WorkQueueRAM.class);
    public static LinkedBlockingDeque<Task> queue = new LinkedBlockingDeque(10000000);
    public static Map<String, Integer> downloadedUrl = new ConcurrentHashMap<String, Integer>();

    @Override
    public void putTask(Task task) {
        if (!bloomFilter.exist(DataUtil.calcMD5(task.getUrl()))) {
            try {
                queue.put(task);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            bloomFilter.add(DataUtil.calcMD5(task.getUrl()));
        }
    }

    @Override
    public long getQueueSize() {
        return queue.size();
    }

    @Override
    public Task getTask() {
        Task task = null;
        try {
            task = queue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return task;
    }
}

