/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.tmptask.workqueue;

import com.bfd.crawler.tmptask.Task;
import com.bfd.crawler.tmptask.bloomfilter.BloomFilter;
import com.bfd.crawler.tmptask.workqueue.IWorkQueue;
import com.bfd.crawler.utils.DataUtil;
import com.bfd.crawler.utils.JacksonUtils;
import com.bfd.crawler.utils.JsonUtils;
import com.bfd.crawler.utils.redisutils.RedisUtil;
import org.apache.log4j.Logger;

public class WorkQueueRedis
implements IWorkQueue {
    public static String queueName = "news_queue";
    public static BloomFilter bloomFilter = new BloomFilter();
    private static Logger log = Logger.getLogger(WorkQueueRedis.class);

    @Override
    public void putTask(Task task) {
        if (!bloomFilter.exist(DataUtil.calcMD5(task.getUrl()))) {
            log.info((Object)("add task :" + JsonUtils.toJSONString(task)));
            RedisUtil.addElement((String)queueName, (String)JsonUtils.toJSONString(task), (String)"");
            bloomFilter.add(DataUtil.calcMD5(task.getUrl()));
        }
    }

    @Override
    public long getQueueSize() {
        return RedisUtil.getSize((String)queueName);
    }

    @Override
    public Task getTask() {
        String taskStr = RedisUtil.bGetElement((String)queueName, (int)3000);
        Task task = null;
        try {
            task = JacksonUtils.extractObject(taskStr, Task.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return task;
    }
}

