/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

class EncodeDetector {
    private boolean found = false;
    private String result;

    public String[] detectEncode(InputStream in, int langFlag) throws IOException {
        String[] prob;
        int len;
        nsDetector det = new nsDetector(langFlag);
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                EncodeDetector.this.found = true;
                EncodeDetector.this.result = charset;
            }
        });
        BufferedInputStream imp = new BufferedInputStream(in);
        byte[] buf = new byte[1024];
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || !det.DoIt(buf, len, false)) continue;
        }
        imp.close();
        in.close();
        det.DataEnd();
        if (isAscii) {
            this.found = true;
            prob = new String[]{"ASCII"};
        } else {
            prob = this.found ? new String[]{this.result} : det.getProbableCharsets();
        }
        return prob;
    }

    public String[] detectChineseEncode(InputStream in) throws IOException {
        return this.detectEncode(in, 2);
    }
}

