/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HbaseConfiguration {
    private static final Log LOG = LogFactory.getLog(HbaseConfiguration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadResource(Properties properties, Object name, boolean quiet) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setNamespaceAware(true);
            try {
                docBuilderFactory.setXIncludeAware(true);
            }
            catch (UnsupportedOperationException e) {
                LOG.error((Object)("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + ":" + e), (Throwable)e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            if (name instanceof InputStream) {
                try {
                    doc = builder.parse((InputStream)name);
                }
                finally {
                    ((InputStream)name).close();
                }
            } else if (name instanceof Element) {
                root = (Element)name;
            }
            if (doc == null && root == null) {
                if (quiet) {
                    return;
                }
                throw new RuntimeException(name + " not found");
            }
            if (root == null) {
                root = doc.getDocumentElement();
            }
            if (!"configuration".equals(root.getTagName())) {
                LOG.fatal((Object)"bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("configuration".equals(prop.getTagName())) {
                    HbaseConfiguration.loadResource(properties, prop, quiet);
                    continue;
                }
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn((Object)"bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                boolean finalParameter = false;
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                        attr = ((Text)field.getFirstChild()).getData().trim();
                        System.out.println("attr:" + attr);
                    }
                    if ("value".equals(field.getTagName()) && field.hasChildNodes()) {
                        value = ((Text)field.getFirstChild()).getData();
                        System.out.println("value:" + value);
                    }
                    if (!"final".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    finalParameter = "true".equals(((Text)field.getFirstChild()).getData());
                    System.out.println("finalParameter:" + finalParameter);
                }
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String hbaseConfig = "<?xml version=\"1.0\"?><?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?><configuration><property><name>hbase.master</name><value>192.168.48.11:60000</value></property><property><name>hbase.zookeeper.property.clientPort</name><value>2181</value></property><property><name>hbase.rootdir</name><value>hdfs://192.168.48.29:8020/hbase</value></property><property><name>hbase.cluster.distributed</name><value>true</value></property><property><name>hbase.zookeeper.quorum</name><value>192.168.48.12,192.168.48.13,192.168.48.14</value></property><property><name>zookeeper.session.timeout</name><value>300000</value></property><property><name>hbase.regionserver.lease.period</name><value>300000</value></property><property><name>zookeeper.znode.parent</name><value>/dp/hbase2</value></property><property><name>hbase.client.write.buffer</name><value>5242880</value></property></configuration>";
        ByteArrayInputStream is = new ByteArrayInputStream(hbaseConfig.getBytes());
        HbaseConfiguration.loadResource(null, is, true);
    }
}

