/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import com.bfd.crawler.utils.MyDateUtil;
import com.bfd.crawler.utils.ParserException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MyStringUtil {
    private static Logger log = Logger.getLogger(MyStringUtil.class);
    private static final Map<String, String> skippedFormats = MyStringUtil.initSkippedFormats();

    public static boolean hasValue(String str) {
        return str != null && !str.trim().equals("");
    }

    public static String getValue(String str) {
        return str == null || str.trim().equals("null") ? "" : str;
    }

    public static String getRegexMatch(String regex, String str) {
        List<String> resultList = MyStringUtil.getRegexMatchList(regex, str);
        return resultList.isEmpty() ? "" : resultList.get(0);
    }

    public static List<String> getRegexMatchList(String regex, String str) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (MyStringUtil.hasValue(str)) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(str);
            while (m.find()) {
                resultList.add(m.group());
            }
        }
        return resultList;
    }

    public static String getRegexGroup(String regex, String str, int id) throws ParserException {
        Pattern p;
        Matcher m;
        String resultStr = "";
        if (MyStringUtil.hasValue(str) && (m = (p = Pattern.compile(regex)).matcher(str.trim())).find()) {
            resultStr = m.group(id);
        }
        if (resultStr.equals("")) {
            log.error((Object)(regex + " parser error!"));
            throw new ParserException("str:" + str.trim().substring(0, str.trim().length() < 100 ? str.trim().length() : 100) + ",regex:" + regex + " parser error!");
        }
        resultStr = resultStr.trim();
        return resultStr;
    }

    public static List<String> getStrListFromRegexGroup(String regex, String str) {
        Pattern p;
        Matcher m;
        ArrayList<String> strList = new ArrayList<String>();
        if (MyStringUtil.hasValue(str) && (m = (p = Pattern.compile(regex)).matcher(str)).find()) {
            for (int i = 0; i <= m.groupCount(); ++i) {
                strList.add(m.group(i));
            }
        }
        return strList;
    }

    public static boolean isRegexMatched(String regex, String str) {
        List<String> resultList = MyStringUtil.getRegexMatchList(regex, str);
        return !resultList.isEmpty();
    }

    public static String getDomain(String url) {
        String regex = ".*://(.*?)/.*";
        try {
            return MyStringUtil.getRegexGroup(regex, url, 1);
        }
        catch (ParserException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getMainDomainFromDomain(String domain) {
        if (domain == null || domain.equals("")) {
            return "";
        }
        String rs = "";
        int length = 0;
        length = domain.endsWith(".com.cn") || domain.endsWith(".gov.cn") || domain.endsWith(".net.cn") || domain.endsWith(".org.cn") || domain.endsWith(".edu.cn") || domain.endsWith(".co.jp") || domain.endsWith(".com.tw") || domain.endsWith(".com.hk") || domain.endsWith(".com.my") || domain.endsWith(".com.co") || domain.endsWith(".com.au") || domain.endsWith(".com.pk") || domain.endsWith(".com.mx") || domain.endsWith(".co.uk") || domain.endsWith(".co.nz") || domain.endsWith(".com.mx") || domain.endsWith(".net.au") ? 2 : 1;
        rs = MyStringUtil.getStrByLengthFromStrArray(domain, length);
        return rs;
    }

    public static String getStrByLengthFromStrArray(String domain, int length) {
        if (domain == null || domain.equals("")) {
            return "";
        }
        String[] arrDomain = domain.split("\\.");
        if (arrDomain.length <= length) {
            return "";
        }
        String rs = "";
        for (int i = length; i >= 0; --i) {
            rs = rs + arrDomain[arrDomain.length - 1 - i] + ".";
        }
        rs = rs.substring(0, rs.length() - 1);
        return rs;
    }

    public static List<String> getAllDomainFromDomain(String domain) {
        List<String> rsList = new ArrayList<String>();
        if (domain == null || domain.equals("")) {
            return rsList;
        }
        int length = 0;
        length = domain.endsWith(".com.cn") || domain.endsWith(".gov.cn") || domain.endsWith(".net.cn") || domain.endsWith(".org.cn") || domain.endsWith(".edu.cn") || domain.endsWith(".co.jp") || domain.endsWith(".com.tw") || domain.endsWith(".com.hk") || domain.endsWith(".com.my") || domain.endsWith(".com.co") || domain.endsWith(".com.au") || domain.endsWith(".com.pk") || domain.endsWith(".com.mx") || domain.endsWith(".co.uk") || domain.endsWith(".co.nz") || domain.endsWith(".com.mx") || domain.endsWith(".net.au") ? 2 : 1;
        rsList = MyStringUtil.getAllSubStrByLengthFromStrArray(domain, length);
        return rsList;
    }

    public static List<String> getAllSubStrByLengthFromStrArray(String domain, int length) {
        int totalLength;
        ArrayList<String> rsList = new ArrayList<String>();
        if (domain == null || domain.equals("")) {
            return rsList;
        }
        String[] arrDomain = domain.split("\\.");
        if (arrDomain.length <= length) {
            return rsList;
        }
        for (int j = totalLength = arrDomain.length - 1; j >= length; --j) {
            String rs = "";
            for (int i = j; i >= 0; --i) {
                rs = rs + arrDomain[arrDomain.length - 1 - i] + ".";
            }
            rsList.add(rs.substring(0, rs.length() - 1));
        }
        return rsList;
    }

    public static String removeAllHtmlTags(String str) {
        if (MyStringUtil.hasValue(str)) {
            return str.replaceAll("<[^<>]+?>", "");
        }
        return "";
    }

    public static String quote(String str) {
        if (MyStringUtil.hasValue(str)) {
            return "'" + str + "'";
        }
        return "";
    }

    public static String quote1(String str) {
        if (MyStringUtil.hasValue(str)) {
            return "\"" + str + "\"";
        }
        return "";
    }

    public static String quoteLike(String str) {
        if (MyStringUtil.hasValue(str)) {
            return "%" + str + "%";
        }
        return "";
    }

    public static String decodeUnicode(String unicodeStr) {
        if (!MyStringUtil.hasValue(unicodeStr)) {
            return "";
        }
        String regex = "&#\\d{5};";
        List<String> unicodes = MyStringUtil.getRegexMatchList(regex, unicodeStr);
        for (String unicode : unicodes) {
            int v = Integer.parseInt(MyStringUtil.getRegexMatch("\\d{5}", unicode));
            if (v < 19968 || v > 40895) continue;
            unicodeStr = unicodeStr.replaceAll(unicode, (char)v + "");
        }
        return unicodeStr;
    }

    public static ArrayList<String> splitIt(String inStr) {
        StringBuffer sbChinese = new StringBuffer();
        StringBuffer sbAlpha = new StringBuffer();
        ArrayList<String> outArray = new ArrayList<String>();
        String[] inStrArray = inStr.trim().split("\\s+");
        for (int j = 0; j < inStrArray.length; ++j) {
            String current = "";
            for (int i = 0; i < inStrArray[j].length(); ++i) {
                current = inStrArray[j].substring(i, i + 1);
                if (current.matches("[\u4e00-\u9fa5]+")) {
                    sbChinese.append(inStrArray[j].substring(i, i + 1));
                    if ((i == inStrArray[j].length() - 1 || inStrArray[j].substring(i + 1, i + 2).matches("[\u4e00-\u9fa5]+")) && i != inStrArray[j].length() - 1) continue;
                    if (sbChinese.length() > 2) {
                        int k = 0;
                        while (k + 2 <= sbChinese.length()) {
                            outArray.add(sbChinese.substring(k, k + 2));
                            ++k;
                        }
                    } else {
                        outArray.add(sbChinese.toString());
                    }
                    sbChinese = new StringBuffer();
                    continue;
                }
                sbAlpha.append(current);
                if (i != inStrArray[j].length() - 1 && inStrArray[j].substring(i + 1, i + 2).matches("[\u4e00-\u9fa5]+")) {
                    outArray.add(sbAlpha.toString());
                    sbAlpha = new StringBuffer();
                    continue;
                }
                if (i != inStrArray[j].length() - 1) continue;
                outArray.add(sbAlpha.toString());
                sbAlpha = new StringBuffer();
            }
        }
        return outArray;
    }

    public static double getSimilar(String ora, String dest) {
        ArrayList<String> oraArray = MyStringUtil.splitIt(ora);
        ArrayList<String> desArray = MyStringUtil.splitIt(dest);
        if (oraArray != null && desArray != null) {
            int q = 0;
            int s = 0;
            int r = 0;
            for (int i = 0; i < oraArray.size(); ++i) {
                if (desArray.indexOf(oraArray.get(i)) != -1) {
                    ++q;
                    continue;
                }
                ++s;
            }
            r = desArray.size() - q;
            return 2.0 * (double)q / (double)(2 * q + r + s);
        }
        return 0.0;
    }

    public static boolean canOmit(String text) {
        if (text == null) {
            return true;
        }
        if (text.length() < 5) {
            return true;
        }
        int uni_count = 0;
        int asc_count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.substring(i, i + 1).matches("[\\u4e00-\\u9fbb]+")) {
                ++uni_count;
                continue;
            }
            ++asc_count;
        }
        return uni_count < 3 && asc_count < 12;
    }

    public static boolean textMatching(String dest, String source, double threshold) {
        boolean flag = false;
        String regex = "&#{0,1}[a-zA-Z0-9]+;";
        String regex2 = "[\\[\\]\\{\\}\u2018\u2019\u201c\u201d'\uff1f?\uff08\uff09\\(\\)\u3010\u3011\uff1a:\u2026\u00b7\uff0c,;\u3002\\.\u3001\uff01\u2014\uff40\u3000\u3003<>\u300a\u300b\u300e\u300f\u300c\u300d\u3008\u3009\\s\\-]";
        String a = dest.replaceAll(regex, "");
        String b = source.replaceAll(regex, "");
        a = a.replaceAll(regex2, "");
        b = b.replaceAll(regex2, "");
        if (MyStringUtil.canOmit(a)) {
            return flag;
        }
        if (a.equals(b) || a.indexOf(b) != -1 || b.indexOf(a) != -1 || (double)b.length() > 30.0 * threshold && a.indexOf(b.substring(0, (int)Math.round(30.0 * threshold))) != -1) {
            return true;
        }
        regex = "&#{0,1}[a-zA-Z0-9]+;";
        regex2 = "[\\[\\]\\{\\}\u2018\u2019\u201c\u201d'\uff1f?\uff08\uff09\\(\\)\u3010\u3011\uff1a:\u2026\u00b7\uff0c,;\u3002\\.\u3001\uff01\u2014\uff40\u3000\u3003<>\u300a\u300b\u300e\u300f\u300c\u300d\u3008\u3009\\-]";
        a = dest.replaceAll(regex, " ");
        b = source.replaceAll(regex, " ");
        double c = MyStringUtil.getSimilar(a = a.replaceAll(regex2, "").toLowerCase(), b = b.replaceAll(regex2, "").toLowerCase());
        if (c > threshold) {
            return true;
        }
        regex = "([\\s]+[\"\\(]+|[\"\\)\\.,:;]+[\\s]+[\"\\(\\.,:;]*|[-]+[\\s]+)";
        a = dest.replaceAll(regex, " ").toLowerCase();
        c = MyStringUtil.getSimilar(a, b = source.replaceAll(regex, " ").toLowerCase());
        if (c > threshold) {
            return true;
        }
        return flag;
    }

    private static int contain(String str, String[] words) {
        if (!MyStringUtil.hasValue(str) || words == null || words.length == 0) {
            return 0;
        }
        int number = 0;
        for (int i = 0; i < words.length; ++i) {
            if (!MyStringUtil.hasValue(words[i]) || !str.toLowerCase().contains(words[i].toLowerCase())) continue;
            ++number;
        }
        if (number == 0) {
            return 0;
        }
        return number == words.length ? 2 : 1;
    }

    public static boolean isContainAny(String str, String[] words) {
        int flag = MyStringUtil.contain(str, words);
        return flag != 0;
    }

    public static boolean isContainAll(String str, String[] words) {
        int flag = MyStringUtil.contain(str, words);
        return flag == 2;
    }

    public static List extractEmailAddressFromString(String addr) {
        ArrayList<String> addrList = null;
        if (addr != null) {
            String regex = "\\w+([-+.']\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(addr);
            addrList = new ArrayList<String>();
            while (m.find()) {
                addrList.add(m.group());
            }
        }
        return addrList;
    }

    public static String loadConvert(String str) {
        if (!MyStringUtil.hasValue(str)) {
            return "";
        }
        char[] in = str.toCharArray();
        int off = 0;
        char[] convtBuf = new char[0];
        int len = str.length();
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String getPercentage(int before, int after) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(1);
        if (0 == before) {
            return "-";
        }
        if (0 != before && 0 == after) {
            return "100%";
        }
        if (0 == before && 0 == after) {
            return "-";
        }
        if (before == after) {
            return "-";
        }
        return nf.format((float)(before - after) / (float)after * 100.0f) + "%";
    }

    public static String getPer(int before, int after) {
        NumberFormat nf = NumberFormat.getInstance();
        return nf.format((float)before / (float)after * 100.0f) + "%";
    }

    public static String getAmountOfIncrease(int before, int after) {
        String result = "";
        if (0 == before) {
            result = "-";
        }
        if (0 != before && 0 == after) {
            result = "+";
        }
        if (before == after) {
            result = "-";
        }
        if (before > after) {
            result = "+";
        }
        if (before < after) {
            result = "-";
        }
        return result;
    }

    public static String getTmpMonth(String dir, String currentdate) {
        String currentMonth = "";
        if ("0".equals(dir)) {
            currentMonth = "\u6700\u8fd1\u4e09\u5341\u5929";
        } else {
            Date tmpdate = MyDateUtil.getDate(currentdate, "yyyyMMdd");
            currentMonth = MyDateUtil.getStr(tmpdate, "yyyy\u5e74MM\u6708");
        }
        return currentMonth;
    }

    public static String getTmpCommon(String dir, String currentdate) {
        Date tmpdate = MyDateUtil.getDate(currentdate, "yyyyMMdd");
        String currentMonth = "";
        currentMonth = "0".equals(dir) ? MyDateUtil.getStr(tmpdate, "yyyy\u5e74") : MyDateUtil.getStr(tmpdate, "yyyy\u5e74MM\u6708");
        return currentMonth;
    }

    public static String getTmpMonth(String dir, int scope, String currentdate) {
        String currentMonth = "";
        Date tmpdate = MyDateUtil.getDate(currentdate, "yyyyMMdd");
        currentMonth = "0".equals(dir) ? (3 == scope ? MyDateUtil.getStr(tmpdate, "yyyy\u5e74MM\u6708dd\u65e5") : "\u6700\u8fd1\u4e09\u5341\u5929") : (3 == scope ? MyDateUtil.getStr(tmpdate, "yyyy\u5e74MM\u6708dd\u65e5") : MyDateUtil.getStr(tmpdate, "yyyy\u5e74MM\u6708"));
        return currentMonth;
    }

    public static String getKeywordFromHtml(String html, String url) {
        String regex = "<meta[\\s\\S]*?name=\"[kK]eywords?\"[\\s\\S]*?content=\"([\\s\\S]*?)\"[\\s\\S]*?>";
        try {
            return MyStringUtil.getRegexGroup(regex, html, 1);
        }
        catch (ParserException e) {
            log.error((Object)("get keyword error url is " + url));
            return "";
        }
    }

    public static String getFileTypeFromUrl(String url) {
        String[] temp;
        String type = "";
        if (url.indexOf(63) > 0) {
            url = url.substring(0, url.indexOf(63));
        }
        if ((temp = url.split("\\.")).length > 1) {
            type = temp[temp.length - 1].toLowerCase();
        }
        return type;
    }

    private static Map<String, String> initSkippedFormats() {
        HashMap<String, String> formats = new HashMap<String, String>();
        formats.put("pdf", ".pdf");
        formats.put("doc", ".doc");
        formats.put("xls", ".xls");
        formats.put("ps", ".ps");
        formats.put("ppt", ".ppt");
        formats.put("rtf", ".rtf");
        return formats;
    }

    public static boolean pre_filtered(String url) {
        if (url == null || url.trim().equals("")) {
            return true;
        }
        String fileType = MyStringUtil.getFileTypeFromUrl(url);
        return skippedFormats.containsKey(fileType);
    }

    public static void main(String[] args) {
        String str = "12\u5e745\u670823\u65e5";
        String regex = "((\\d+)\\s*\u5e74)?(\\d+)\\s*\u6708(\\d+)\\s*\u65e5";
        try {
            String rs = MyStringUtil.getRegexGroup(regex, str, 2);
            System.out.println(rs);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }
}

