/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import com.bfd.crawler.utils.Book;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxUtil
extends DefaultHandler {
    private List<Book> books = null;
    private Book book = null;
    private String preTag = null;

    public List<Book> getBooks(InputStream xmlStream) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        SaxUtil handler = new SaxUtil();
        parser.parse(xmlStream, (DefaultHandler)handler);
        return handler.getBooks();
    }

    public List<Book> getBooks() {
        return this.books;
    }

    @Override
    public void startDocument() throws SAXException {
        this.books = new ArrayList<Book>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("book".equals(qName)) {
            this.book = new Book();
            this.book.setId(Integer.parseInt(attributes.getValue(0)));
        }
        this.preTag = qName;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("book".equals(qName)) {
            this.books.add(this.book);
            this.book = null;
        }
        this.preTag = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.preTag != null) {
            String content = new String(ch, start, length);
            if ("name".equals(this.preTag)) {
                this.book.setName(content);
            } else if ("price".equals(this.preTag)) {
                this.book.setPrice(Float.parseFloat(content));
            }
        }
    }

    public static void main(String[] args) {
        SaxUtil sax = new SaxUtil();
        InputStream input = sax.getClass().getClassLoader().getResourceAsStream("book.xml");
        List<Book> books = null;
        try {
            books = sax.getBooks(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Book book : books) {
            System.out.println(book.toString());
        }
    }
}

