/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.zookeeper;

import com.bfd.crawler.utils.JsonUtils;
import com.bfd.crawler.utils.zookeeper.ZookeeperUtil;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZKCache {
    public static final Log LOG = LogFactory.getLog((String)"schedule");
    private static Map<String, String> configMap = null;
    private static Map<String, String> weightConfigMap = null;
    private static Map<String, Object> dbconfigMap = null;

    public static synchronized Map<String, String> getConfigMap() {
        if (configMap == null) {
            configMap = ZKCache.loadConfigMap();
            LOG.info((Object)"success to load config from zk...");
        }
        return configMap;
    }

    public static synchronized Map<String, String> getWeightConfigMap() {
        if (weightConfigMap == null) {
            weightConfigMap = ZKCache.loadWeightConfigMap();
            LOG.info((Object)"success to load weightconfig from zk...");
        }
        return weightConfigMap;
    }

    public static synchronized Map<String, Object> getDBConfigMap() {
        if (dbconfigMap == null) {
            dbconfigMap = ZKCache.loadDBConfigMap();
            LOG.info((Object)"success to load dbconfig.xml from zk...");
        }
        return dbconfigMap;
    }

    private static Map<String, String> loadConfigMap() {
        String iceConfig = "/crawler/sys/etc/config";
        String data = ZookeeperUtil.loadConfig(iceConfig);
        if (data == null) {
            return null;
        }
        Map map = null;
        try {
            map = JsonUtils.parseObject(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> loadWeightConfigMap() {
        String wcConfig = "/crawler/sys/etc/weightconfig";
        String data = ZookeeperUtil.loadConfig(wcConfig);
        if (data == null) {
            return null;
        }
        Map map = null;
        try {
            map = JsonUtils.parseObject(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, Object> loadDBConfigMap() {
        String dbConfig = "/crawler/sys/etc/dbconfig.xml";
        String data = ZookeeperUtil.loadConfig(dbConfig);
        if (data == null) {
            return null;
        }
        Map map = null;
        try {
            map = JsonUtils.parseObject(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

