/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.zookeeper;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZookeeperUtil {
    private static final Log LOG = LogFactory.getLog(ZookeeperUtil.class);
    private static ZooKeeper zk = null;
    private static String connectString = "";
    private static final int sessionTimeout = 2000;

    public static ZooKeeper getInstance() {
        if (zk == null) {
            zk = ZookeeperUtil.init();
        }
        return zk;
    }

    private static ZooKeeper init() {
        Properties properties = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream("../etc/zk.conf"));
            properties.load(is);
            Object obj = properties.get("connectionArgs");
            connectString = obj == null ? "" : obj.toString();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)"ZookeeperUtil:zk.conf not exist");
            e.printStackTrace();
        }
        catch (IOException e) {
            LOG.info((Object)"ZookeeperUtil:zk init IO's problems");
            e.printStackTrace();
        }
        final CountDownLatch connectionLatch = new CountDownLatch(1);
        try {
            zk = new ZooKeeper(connectString, 2000, new Watcher(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void process(WatchedEvent event) {
                    Watcher.Event.KeeperState stat = event.getState();
                    if (stat == Watcher.Event.KeeperState.SyncConnected) {
                        connectionLatch.countDown();
                        return;
                    }
                    if (stat == Watcher.Event.KeeperState.Disconnected) {
                        return;
                    }
                    if (stat == Watcher.Event.KeeperState.AuthFailed) {
                        return;
                    }
                    if (stat != Watcher.Event.KeeperState.Expired) return;
                    while (true) {
                        try {
                            zk.close();
                            zk = new ZooKeeper(connectString, 2000, (Watcher)this);
                            return;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
        }
        catch (IOException e) {
            LOG.info((Object)"ZookeeperUtil:zk init process IO's problems");
            e.printStackTrace();
        }
        try {
            connectionLatch.await();
        }
        catch (InterruptedException e) {
            LOG.info((Object)"ZookeeperUtil:zk init Interrupted problems");
            e.printStackTrace();
        }
        LOG.info((Object)"ZookeeperUtil: the success for geting the zookeeper connection instance");
        return zk;
    }

    public static String loadConfig(String nodePath) {
        zk = ZookeeperUtil.getInstance();
        String data = null;
        try {
            if (zk.exists(nodePath, false) == null) {
                LOG.error((Object)("config:" + nodePath + " not exist"));
                return data;
            }
            byte[] temp = zk.getData(nodePath, false, null);
            data = new String(temp);
            return data;
        }
        catch (KeeperException e) {
            e.printStackTrace();
            return data;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return data;
        }
    }

    public static void recursionDeleteNode(String nodePath) {
        zk = ZookeeperUtil.getInstance();
        try {
            if (zk.exists(nodePath, false) == null) {
                LOG.error((Object)("config:" + nodePath + " not exist"));
            }
            List subNodes = zk.getChildren(nodePath, false);
            for (String subNode : subNodes) {
                ZookeeperUtil.recursionDeleteNode(nodePath + "/" + subNode);
            }
            zk.delete(nodePath, -1);
            LOG.error((Object)("delete note :" + nodePath));
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getDataAndMonitor(String nodePath, Watcher watcher, ZooKeeper zk) {
        String data = null;
        try {
            if (zk.exists(nodePath, false) == null) {
                System.out.println("config:" + nodePath + " not exist");
                return data;
            }
            byte[] temp = zk.getData(nodePath, watcher, null);
            data = new String(temp);
            return data;
        }
        catch (KeeperException e) {
            e.printStackTrace();
            return data;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return data;
        }
    }

    public static Stat setData(String path, String data) {
        zk = ZookeeperUtil.getInstance();
        Stat rs = null;
        try {
            rs = zk.setData(path, data.getBytes(), -1);
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100000; ++i) {
            ZookeeperUtil.recursionDeleteNode("/brokers/topics/testkafka" + i);
        }
    }
}

