/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.kafka.reader;

import com.bfd.dp.kfk.util.LoadConfig;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.message.Message;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;

public class ConsumerInstance {
    private static final Logger LOG = Logger.getLogger(ConsumerInstance.class);
    private static String zkconnect;
    private static String zksessiontimeoutms;
    private static String zkconnectiontimeoutms;
    private static String autocommitintervalms;
    private static String consumertimeoutms;
    private ConsumerIterator<Message> it;
    private int flag;
    public ConsumerConnector consumer;
    private String interGroup;
    public long timeStamp;

    public ConsumerInstance() {
        Date myDate = new Date();
        this.timeStamp = myDate.getTime() / 1000L;
        this.flag = 0;
    }

    public static void getConfig() throws Exception {
        Properties pro = LoadConfig.getInstance().getPro("../etc/config");
        zkconnect = pro.getProperty("dsp_kafkazk_address", "192.168.50.11:2191,192.168.50.12:2191,192.168.50.13:2191,192.168.50.14:2191,192.168.50.15:2191/kafka07dmp");
        LOG.info((Object)("zkconnect:" + zkconnect));
        zksessiontimeoutms = pro.getProperty("sessionTimeOut", "50000");
        zkconnectiontimeoutms = pro.getProperty("connectionTimeOut", "500000");
        autocommitintervalms = pro.getProperty("autocommitinterval", "10000");
        consumertimeoutms = pro.getProperty("consumertimeout", "30000");
    }

    private void Init(String topic, String groupid, int type) {
        String groupStr;
        long mytime;
        Date myDate;
        this.interGroup = groupid;
        try {
            ConsumerInstance.getConfig();
        }
        catch (Exception e) {
            LOG.error((Object)(Thread.currentThread().getName() + "Can not get config info!"));
            System.exit(1);
        }
        Properties props = new Properties();
        if (type == 0) {
            props.put("groupid", groupid);
            props.put("consumer.timeout.ms", consumertimeoutms);
        } else if (type == 1) {
            myDate = new Date();
            mytime = myDate.getTime() / 1000L;
            groupStr = mytime + "";
            props.put("groupid", groupStr);
            props.put("consumer.timeout.ms", consumertimeoutms);
        } else if (type == 12) {
            props.put("groupid", groupid);
            props.put("autocommit.enable", (Object)false);
            props.put("consumer.timeout.ms", consumertimeoutms);
        } else if (type == 2) {
            props.put("groupid", groupid);
            props.put("consumer.timeout.ms", "-1");
        } else if (type == 3) {
            myDate = new Date();
            mytime = myDate.getTime() / 1000L;
            groupStr = mytime + "";
            props.put("groupid", groupStr);
            props.put("consumer.timeout.ms", "-1");
        }
        props.put("zk.connect", zkconnect);
        props.put("zk.sessiontimeout.ms", zksessiontimeoutms);
        props.put("zk.connectiontimeout.ms", zkconnectiontimeoutms);
        props.put("autocommit.interval.ms", autocommitintervalms);
        ConsumerConfig consumerconfig = new ConsumerConfig(props);
        if (this.consumer != null) {
            this.close();
        }
        this.consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)consumerconfig);
        HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
        topicCountMap.put(topic, 1);
        Map consumerMap = this.consumer.createMessageStreams(topicCountMap);
        KafkaStream stream = (KafkaStream)((List)consumerMap.get(topic)).get(0);
        this.it = stream.iterator();
    }

    public RetInfo get(String topic, String group) {
        RetInfo ret = new RetInfo();
        Date myDate = new Date();
        this.timeStamp = myDate.getTime() / 1000L;
        if (this.flag == 0) {
            try {
                this.Init(topic, group, 0);
            }
            catch (Exception e) {
                LOG.error((Object)(Thread.currentThread().getName() + " init kafka consuer error"), (Throwable)e);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.flag = 0;
                ret.ret = -1;
                return ret;
            }
            this.flag = 1;
        }
        try {
            if (this.it.hasNext()) {
                ByteBuffer buffer = ((Message)this.it.next().message()).payload();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                ret.message = new String(bytes);
                ret.ret = 1;
                return ret;
            }
        }
        catch (ConsumerTimeoutException e) {
            ret.ret = 0;
            this.flag = 0;
            return ret;
        }
        catch (Exception e) {
            LOG.error((Object)(Thread.currentThread().getName() + "get kafka data error"), (Throwable)e);
            this.flag = 0;
            ret.ret = -1;
            return ret;
        }
        return null;
    }

    public RetInfo getBlock(String topic, String group) {
        RetInfo ret = new RetInfo();
        Date myDate = new Date();
        this.timeStamp = myDate.getTime() / 1000L;
        if (this.flag == 0) {
            this.Init(topic, group, 2);
            this.flag = 1;
        }
        try {
            if (this.it.hasNext()) {
                ByteBuffer buffer = ((Message)this.it.next().message()).payload();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                ret.message = new String(bytes);
                ret.ret = 1;
                return ret;
            }
        }
        catch (ConsumerTimeoutException e) {
            ret.ret = 0;
            return ret;
        }
        catch (Exception e) {
            LOG.error((Object)(Thread.currentThread().getName() + "get kafka data error"), (Throwable)e);
            ret.ret = -1;
            return ret;
        }
        return null;
    }

    public void close() {
        this.consumer.commitOffsets();
        this.consumer.shutdown();
        this.flag = 0;
    }

    public void closeAndDelete() {
        this.consumer.shutdown();
        this.flag = 0;
        ZkClient zk = new ZkClient(zkconnect);
        zk.deleteRecursive("/consumers/" + this.interGroup);
        zk.close();
    }

    public static void main(String[] args) {
        try {
            ConsumerInstance.getConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class RetInfo {
        public String message;
        public int ret;
    }
}

