/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.templateParser;

import com.fuwenchao.templateParser.DomCFGBlock;
import com.fuwenchao.templateParser.DomCFGElement;
import com.fuwenchao.templateParser.DomCFGField;
import com.fuwenchao.templateParser.DomSearch;
import com.fuwenchao.templateParser.Template;
import com.fuwenchao.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class DomCFGTree
implements Comparable<DomCFGTree>,
DomCFGElement {
    private static final Log log = LogFactory.getLog(DomCFGTree.class);
    private String[] required;
    private Map<String, Boolean> output;
    private int num = 0;
    private int active = 0;
    private int id;
    private String type;
    private boolean indexMatch;
    private String[] path;
    private ArrayList<DomCFGField> fields;
    private ArrayList<DomCFGTree> children;
    private ArrayList<DomCFGBlock> blocks;

    public DomCFGTree() {
    }

    public DomCFGTree(Node node) {
        String sName = node.getNodeName();
        if (!("node".equalsIgnoreCase(sName) || "tmpl".equalsIgnoreCase(sName) || "block".equalsIgnoreCase(sName))) {
            return;
        }
        this.type = DomSearch.getNodeAttr(node, "type", "");
        String stmp = DomSearch.getNodeAttr(node, "path", "");
        if (stmp.length() > 0) {
            this.path = stmp.split("/");
        }
        if ((stmp = DomSearch.getNodeAttr(node, "required", "")).length() > 0) {
            this.required = stmp.split(",");
        }
        this.output = new HashMap<String, Boolean>();
        stmp = DomSearch.getNodeAttr(node, "output", "");
        if (stmp.length() > 0) {
            String[] ss = stmp.split(",");
            for (int i = 0; i < ss.length; ++i) {
                this.output.put(ss[i], true);
            }
        }
        this.fields = new ArrayList();
        this.children = new ArrayList();
        this.blocks = new ArrayList();
        stmp = DomSearch.getNodeAttr(node, "matchByIndex", "");
        this.indexMatch = false;
        if (stmp.equalsIgnoreCase("true")) {
            this.indexMatch = true;
        }
        if (sName.equalsIgnoreCase("block")) {
            this.blocks.add(new DomCFGBlock(node));
        } else {
            for (Node cld = node.getFirstChild(); cld != null; cld = cld.getNextSibling()) {
                String childName = cld.getNodeName();
                if (childName.equalsIgnoreCase("node")) {
                    this.children.add(new DomCFGTree(cld));
                    continue;
                }
                if (childName.equalsIgnoreCase("fld")) {
                    this.fields.add(new DomCFGField(cld));
                    continue;
                }
                if (!childName.equalsIgnoreCase("block")) continue;
                this.blocks.add(new DomCFGBlock(cld));
            }
        }
    }

    public DomCFGTree(Node node, Template template) {
        String sName = node.getNodeName();
        if (StringUtils.isEmpty((String)sName) || !"node".equalsIgnoreCase(sName) && !"tmpl".equalsIgnoreCase(sName) && !"block".equalsIgnoreCase(sName)) {
            return;
        }
        this.type = template.getType();
        this.num = template.getNum();
        this.active = template.getActive();
        this.id = template.getId();
        String stmp = template.getRequired();
        if (stmp.length() > 0) {
            this.required = stmp.split(",");
        }
        if ((stmp = DomSearch.getNodeAttr(node, "path", "")).length() > 0) {
            this.path = stmp.split("/");
        }
        this.output = new HashMap<String, Boolean>();
        stmp = template.getOutput();
        if (stmp.length() > 0) {
            String[] ss = stmp.split(",");
            for (int i = 0; i < ss.length; ++i) {
                this.output.put(ss[i], true);
            }
        }
        this.fields = new ArrayList();
        this.children = new ArrayList();
        this.blocks = new ArrayList();
        stmp = DomSearch.getNodeAttr(node, "matchByIndex", "");
        this.indexMatch = false;
        if (stmp.equalsIgnoreCase("true")) {
            this.indexMatch = true;
        }
        if (sName.equalsIgnoreCase("block")) {
            this.blocks.add(new DomCFGBlock(node));
        } else {
            for (Node cld = node.getFirstChild(); cld != null; cld = cld.getNextSibling()) {
                String childName = cld.getNodeName();
                if ("node".equalsIgnoreCase(childName)) {
                    this.children.add(new DomCFGTree(cld));
                    continue;
                }
                if ("fld".equalsIgnoreCase(childName)) {
                    this.fields.add(new DomCFGField(cld));
                    continue;
                }
                if (!"block".equalsIgnoreCase(childName)) continue;
                this.blocks.add(new DomCFGBlock(cld));
            }
        }
    }

    public boolean isMatchByIndex() {
        return this.indexMatch;
    }

    public String[] getTreePath() {
        return this.path;
    }

    public List<DomCFGField> getFields() {
        return this.fields;
    }

    public List<DomCFGTree> getChildren() {
        return this.children;
    }

    public List<DomCFGBlock> getBlocks() {
        return this.blocks;
    }

    public String getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public Integer getNum() {
        return this.num;
    }

    public Integer getActive() {
        return this.active;
    }

    public String[] getRequiredField() {
        return this.required;
    }

    public Map<String, Boolean> getOutputField() {
        return this.output;
    }

    public String toString() {
        int i;
        String res = "";
        if (this.path == null) {
            res = res + "No path";
        } else {
            for (i = 0; i < this.path.length; ++i) {
                res = i > 0 ? res + "/" + this.path[i] : res + "path=" + this.path[i];
            }
        }
        for (i = 0; i < this.fields.size(); ++i) {
            res = res + ",field-" + i + ": " + this.fields.get(i).toString();
        }
        for (i = 0; i < this.children.size(); ++i) {
            res = res + ",child-" + i + ": " + this.children.get(i).toString();
        }
        res = this.type == "" ? res + ",No type" : res + ",type=" + this.type;
        res = res + ",num=" + this.num;
        res = res + ",active=" + this.active;
        for (i = 0; i < this.blocks.size(); ++i) {
            res = res + ",mokes-" + i + ": " + this.blocks.get(i).toString();
        }
        if (this.required != null) {
            res = res + ", required:";
            for (i = 0; i < this.required.length; ++i) {
                res = res + " " + this.required[i];
            }
        }
        res = res + ", output fields:";
        Object[] objs = this.output.keySet().toArray();
        for (int i2 = 0; i2 < objs.length; ++i2) {
            res = res + " " + (String)objs[i2];
        }
        return res;
    }

    @Override
    public int compareTo(DomCFGTree tree) {
        if (tree.getNum() > this.getNum()) {
            return 1;
        }
        if (tree.getNum() < this.getNum()) {
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        ArrayList<DomCFGTree> trees = new ArrayList<DomCFGTree>();
        DomCFGTree e = new DomCFGTree();
        e.num = 10;
        DomCFGTree e1 = new DomCFGTree();
        e1.num = 5;
        DomCFGTree e2 = new DomCFGTree();
        e2.num = 8;
        trees.add(e);
        trees.add(e1);
        trees.add(e2);
        System.out.println(JsonUtil.toJSONString(trees));
        Collections.sort(trees);
        System.out.println(JsonUtil.toJSONString(trees));
    }
}

