/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.thread.volatiletest;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAtomic {
    public static AtomicInteger counter_integer;
    public static int count_int;

    @Before
    public void setUp() {
        counter_integer = new AtomicInteger(0);
    }

    @Test
    public void testAtomic() throws InterruptedException {
        int threadCount = 100;
        int loopCount = 0x9898D8;
        CountDownLatch latch_1 = new CountDownLatch(1);
        CountDownLatch latch_n = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            AtomicIntegerThread thread = new AtomicIntegerThread(latch_1, latch_n, loopCount);
            thread.start();
        }
        long startNano = System.nanoTime();
        latch_1.countDown();
        latch_n.await();
        long endNano = System.nanoTime();
        int sum = counter_integer.get();
        Assert.assertEquals((String)"sum \u4e0d\u7b49\u4e8e threadCount * loopCount,\u6d4b\u8bd5\u5931\u8d25", (long)sum, (long)(threadCount * loopCount));
        System.out.println("--------testAtomic(); \u9884\u671f\u4e24\u8005\u76f8\u7b49------------");
        System.out.println("\u8017\u65f6: " + (endNano - startNano) / 1000000L + "ms");
        System.out.println("threadCount = " + threadCount + ";");
        System.out.println("loopCount = " + loopCount + ";");
        System.out.println("sum = " + sum + ";");
    }

    @Test
    public void testIntAdd() throws InterruptedException {
        int threadCount = 100;
        int loopCount = 0x9898D8;
        CountDownLatch latch_1 = new CountDownLatch(1);
        CountDownLatch latch_n = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            IntegerThread thread = new IntegerThread(latch_1, latch_n, loopCount);
            thread.start();
        }
        long startNano = System.nanoTime();
        latch_1.countDown();
        latch_n.await();
        long endNano = System.nanoTime();
        int sum = count_int;
        Assert.assertNotEquals((String)"sum \u7b49\u4e8e threadCount * loopCount,testIntAdd()\u6d4b\u8bd5\u5931\u8d25", (long)sum, (long)(threadCount * loopCount));
        System.out.println("-------testIntAdd(); \u9884\u671f\u4e24\u8005\u4e0d\u76f8\u7b49---------");
        System.out.println("\u8017\u65f6: " + (endNano - startNano) / 1000000L + "ms");
        System.out.println("threadCount = " + threadCount + ";");
        System.out.println("loopCount = " + loopCount + ";");
        System.out.println("sum = " + sum + ";");
    }

    static {
        count_int = 0;
    }

    class IntegerThread
    extends Thread {
        private CountDownLatch latch = null;
        private CountDownLatch latchdown = null;
        private int loopCount;

        public IntegerThread(CountDownLatch latch, CountDownLatch latchdown, int loopCount) {
            this.latch = latch;
            this.latchdown = latchdown;
            this.loopCount = loopCount;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < this.loopCount; ++i) {
                ++count_int;
            }
            this.latchdown.countDown();
        }
    }

    class AtomicIntegerThread
    extends Thread {
        private CountDownLatch latch = null;
        private CountDownLatch latchdown = null;
        private int loopCount;

        public AtomicIntegerThread(CountDownLatch latch, CountDownLatch latchdown, int loopCount) {
            this.latch = latch;
            this.latchdown = latchdown;
            this.loopCount = loopCount;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < this.loopCount; ++i) {
                counter_integer.getAndIncrement();
            }
            this.latchdown.countDown();
        }
    }
}

