/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.tmptask.huafen.parser;

import com.bfd.crawler.utils.FileUtil;
import com.bfd.crawler.utils.JsonUtils;
import com.fuwenchao.tmptask.Constants;
import com.fuwenchao.tmptask.Iparser;
import com.fuwenchao.tmptask.Task;
import com.fuwenchao.tmptask.Utils;
import com.fuwenchao.tmptask.WorkQueue;
import com.fuwenchao.tmptask.huafen.HuafenUtils;
import com.fuwenchao.utils.httpclient.MyCrawler;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XPatherException;

public class HuaFenListParser
implements Iparser {
    public static long totalNum = 0L;
    private static Logger log = Logger.getLogger(HuaFenListParser.class);
    public static Pattern pList = Pattern.compile("<a\\s+?class=\"s xst\"[\\s\\S]*?href=\"(.*?)\"");

    @Override
    public Map<String, Object> parseHtml(String html, Task task) {
        try {
            HtmlCleaner cleaner = new HtmlCleaner();
            TagNode root = cleaner.clean(html);
            Object[] tableObjs = root.evaluateXPath("//table[@id='threadlisttableid']");
            Object[] hrefObjs = ((TagNode)tableObjs[0]).evaluateXPath(".//a[@class='s xst']");
            for (int i = 0; i < hrefObjs.length; ++i) {
                String tempUrl = ((TagNode)hrefObjs[i]).getAttributeByName("href");
                Task itemTask = new Task();
                itemTask.setUrl(HuafenUtils.formatUrl(tempUrl));
                itemTask.setType(Constants.TASK_TYPE_ITEM);
                WorkQueue.putTask(itemTask);
            }
            log.info((Object)(Utils.getCurrentThreadName() + " url:" + task.getUrl() + ".get items size is " + hrefObjs.length));
            log.info((Object)(Utils.getCurrentThreadName() + " now total totalNum is " + (totalNum += (long)hrefObjs.length)));
            this.getListPage(root, task.getUrl());
            this.getSubList(root, task.getUrl());
            this.getReplys2Clicks(root, task);
        }
        catch (XPatherException e1) {
            e1.printStackTrace();
            log.error((Object)("error url : " + task.getUrl()));
        }
        return null;
    }

    private void getReplys2Clicks(TagNode root, Task task) {
        try {
            Object[] tbodys = root.evaluateXPath("//table[@id='threadlisttableid']/tbody");
            if (tbodys.length == 0) {
                return;
            }
            for (Object tbody : tbodys) {
                TagNode tableTag = (TagNode)tbody;
                Object[] replys = tableTag.evaluateXPath("//span[@class='thd-ico thd-replies']");
                Object[] clicks = tableTag.evaluateXPath("//span[@class='thd-ico thd-view']");
                Object[] as = tableTag.evaluateXPath("//a[@class='s xst']");
                if (replys.length == 0 || clicks.length == 0 || as.length == 0) continue;
                String reply = ((TagNode)replys[0]).getText().toString();
                String click = ((TagNode)clicks[0]).getText().toString();
                String a = HuafenUtils.formatUrl(((TagNode)as[0]).getAttributeByName("href"));
                String rs = task.getUrl() + "\t" + a + "\t" + click + "\t" + reply + "\n";
                FileUtil.appendToFile((String)"huafenInfoCount", (String)rs);
                log.info((Object)rs);
            }
        }
        catch (XPatherException e) {
            e.printStackTrace();
            log.error((Object)("error url : " + task.getUrl()));
        }
    }

    private void getSubList(TagNode root, String url) {
        try {
            Object[] objs = root.evaluateXPath("//div[@class='bm_c']");
            if (objs.length == 0) {
                return;
            }
            TagNode table = (TagNode)objs[0];
            for (Object obj : objs = table.evaluateXPath("//td[@class='fl_g']/dl[1]/dt[1]/a[1]")) {
                TagNode a = (TagNode)obj;
                String subUrl = a.getAttributeByName("href");
                Task itemTask = new Task();
                itemTask.setUrl(HuafenUtils.formatUrl(subUrl));
                itemTask.setType(Constants.TASK_TYPE_LIST);
                log.info((Object)("get sublisturltask:" + JsonUtils.toJSONString((Object)itemTask)));
            }
            log.info((Object)(Utils.getCurrentThreadName() + "url:" + url + " get sublist task count is " + objs.length));
        }
        catch (XPatherException e) {
            e.printStackTrace();
            log.error((Object)("error url : " + url));
        }
    }

    private void getListPage(TagNode root, String url) {
        try {
            Object[] objs = root.evaluateXPath("//div[@class='pg']");
            if (objs == null || objs.length == 0) {
                log.info((Object)(Utils.getCurrentThreadName() + " url:" + url + ".no page!"));
                return;
            }
            Object[] hrefs = ((TagNode)objs[0]).evaluateXPath(".//a");
            for (int i = 0; i < hrefs.length; ++i) {
                String tempUrl = ((TagNode)hrefs[i]).getAttributeByName("href");
                Task task = new Task();
                task.setUrl(HuafenUtils.formatUrl(tempUrl));
                task.setType(Constants.TASK_TYPE_LIST);
                WorkQueue.putTask(task);
            }
            log.info((Object)(Utils.getCurrentThreadName() + " url:" + url + ".get list page size is " + hrefs.length));
        }
        catch (XPatherException e1) {
            e1.printStackTrace();
            log.error((Object)(Utils.getCurrentThreadName() + " the error url is " + url));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)(Utils.getCurrentThreadName() + " error url is " + url));
        }
    }

    public static void main(String[] args) {
        String entranceUrl = "http://www.huafans.cn/forum-173-1.html";
        String html = new MyCrawler().get(entranceUrl)[1];
        System.out.println(html);
        Task task = new Task();
        task.setUrl(entranceUrl);
        new HuaFenListParser().parseHtml(html, task);
    }
}

