/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.tmptask.movienet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadConfig {
    public static final Log LOG = LogFactory.getLog(LoadConfig.class);
    private static LoadConfig loadConfig = null;
    private Properties pro = null;
    private Map<String, Properties> mapro = new HashMap<String, Properties>();

    public void destroy() {
        this.pro = null;
    }

    private LoadConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getconfig(String file) {
        LOG.debug((Object)(Thread.currentThread().getName() + "--------------- Load config ----------------" + file));
        Properties pro = null;
        InputStream stream = LoadConfig.class.getClassLoader().getResourceAsStream(file);
        if (stream == null) {
            try {
                File f = new File(file);
                if (f.exists()) {
                    stream = new FileInputStream(f);
                }
            }
            catch (SecurityException ex) {
                LOG.error((Object)"security manager may forbid access to the local file system");
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)(file + " not found"), (Throwable)e);
            }
        }
        pro = new Properties();
        if (stream == null) {
            return pro;
        }
        try {
            pro.load(stream);
        }
        catch (IOException e) {
            LOG.error((Object)("read " + file + " error"), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("read " + file + " error"), (Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)("read " + file + " error"), (Throwable)e);
            }
            stream = null;
        }
        LOG.debug((Object)(Thread.currentThread().getName() + "--------------- init done ----------------" + file));
        return pro;
    }

    public static LoadConfig getInstance(String configPath) {
        if (loadConfig == null) {
            loadConfig = new LoadConfig();
        }
        return loadConfig;
    }

    public static LoadConfig getInstance() {
        if (loadConfig == null) {
            loadConfig = new LoadConfig();
        }
        return loadConfig;
    }

    public Properties getPro(String filename) {
        if (this.mapro.containsKey(filename)) {
            this.pro = this.mapro.get(filename);
        } else {
            this.pro = this.getconfig(filename);
            this.mapro.put(filename, this.pro);
        }
        return this.pro;
    }

    public static void main(String[] args) {
        Properties pro = LoadConfig.getInstance().getPro("weightconfig");
        LOG.info((Object)LoadConfig.getInstance().getPro("config"));
        LOG.info((Object)LoadConfig.getInstance().getPro("weightconfig"));
        LOG.info((Object)LoadConfig.getInstance().getPro("test"));
        LOG.info((Object)LoadConfig.getInstance().getPro("config"));
        Set<Object> set = pro.keySet();
        for (Object o : set) {
            String tempKey = o.toString();
            String value = pro.getProperty(tempKey);
            LOG.info((Object)(tempKey + ":" + value));
        }
    }
}

