/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigUtils {
    private static final Log LOG = LogFactory.getLog(ConfigUtils.class);
    private static final String regex = "parse-.*\\.properties";
    private Properties properties = new Properties();
    private static ConfigUtils instance = new ConfigUtils();
    private Set<String> dirSet = new HashSet<String>();

    private ConfigUtils() {
        this.init();
    }

    public static ConfigUtils getInstance() {
        return instance;
    }

    private void init() {
        FileFilter fileFilter = new FileFilter(){
            Pattern pattern = Pattern.compile("parse-.*\\.properties");
            Matcher matcher = null;

            @Override
            public boolean accept(File pathname) {
                if (pathname != null && pathname.isFile() && pathname.getName() != null) {
                    this.matcher = this.pattern.matcher(pathname.getName());
                    return this.matcher.matches();
                }
                return false;
            }
        };
        this.readDir("../etc", fileFilter);
    }

    private void readDir(String pathname, FileFilter filter) {
        if (this.dirSet.contains(pathname)) {
            return;
        }
        this.dirSet.add(pathname);
        if (StringUtils.isNotEmpty((String)pathname)) {
            File[] files;
            File file = new File(pathname);
            LOG.info((Object)("check dir to find config file, dir=" + file.getAbsolutePath()));
            if (file.isDirectory() && (files = file.listFiles(filter)) != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    this.readFile(files[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(File file) {
        if (file != null && file.canRead()) {
            Reader reader = null;
            try {
                Properties p = new Properties();
                reader = new FileReader(file);
                p.load(reader);
                if (!p.isEmpty()) {
                    this.properties.putAll((Map<?, ?>)p);
                }
                LOG.info((Object)("read properties file, filename=" + file.getAbsolutePath()));
            }
            catch (Exception ex) {
                LOG.warn((Object)ex.getMessage());
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOG.warn((Object)ex.getMessage());
                }
            }
        }
    }

    public void readFiles(Set<String> fileStrs) {
        for (String str : fileStrs) {
            this.readFile(new File(str));
        }
    }

    public String getProp(String key) {
        return this.properties.getProperty(key);
    }

    public String getProp(String key, String defaultValue) {
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        LOG.info((Object)("key=" + key + ", will use defaultValue=" + defaultValue));
        return defaultValue;
    }

    public int getIntProp(String key, int defaultValue) {
        String value = this.getProp(key);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        LOG.info((Object)("key=" + key + ", will use defaultValue=" + defaultValue));
        return defaultValue;
    }

    public boolean getBoolProp(String key, boolean defaultValue) {
        String value = this.getProp(key);
        try {
            if (value != null) {
                return Boolean.valueOf(value);
            }
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        LOG.info((Object)("key=" + key + ", will use defaultValue=" + defaultValue));
        return defaultValue;
    }

    public long getLongProp(String key, long defaultValue) {
        String value = this.getProp(key);
        try {
            if (value != null) {
                return Long.parseLong(value);
            }
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        LOG.info((Object)("key=" + key + ", will use defaultValue=" + defaultValue));
        return defaultValue;
    }

    public static void main(String[] args) {
        ConfigUtils.getInstance().readFile(new File("../etc/zk.conf"));
        System.out.println(ConfigUtils.getInstance().getProp("connectionArgs"));
    }
}

