/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonUtil {
    private static final Log log = LogFactory.getLog(JsonUtil.class);
    private static JsonFactory _jsonFactory = null;
    public static final String REQUEST_JUDGE_RULES = "{\"req\":\"judge_rule\"}";
    public static final String REQUEST_ITEMFLDMAPRULES = "{\"req\":\"itemFldMapRule\"}";
    public static final String REQUEST_PARSECONFIG = "{\"req\":\"parseConfig\"}";
    public static final String REQUEST_WEBSITE = "{\"req\":\"website\"}";
    public static final String REQUEST_TEMPLATE = "{\"req\":\"template\",\"type\":\"ALL\"}";
    public static final String REQUEST_PLUGIN = "{\"req\":\"plugin\",\"type\":\"ALL\"}";

    public static String toJSONString(Object object) {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        try {
            return om.writeValueAsString(object);
        }
        catch (Exception e) {
            log.warn((Object)"to json string exception, will use fastjson to parse", (Throwable)e);
            return JSON.toJSONString((Object)object);
        }
    }

    public static Object parseObject(String str) throws Exception {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        return om.readValue(str.getBytes(), Object.class);
    }

    public static List parseArray(String str) throws Exception {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        return (List)om.readValue(str.getBytes(), Object.class);
    }

    public static boolean getRuleResult(String rules) throws Exception {
        JsonUtil.parseObject(rules);
        return false;
    }

    public static void main(String[] args) {
    }

    static {
        if (_jsonFactory == null) {
            _jsonFactory = new JsonFactory();
            _jsonFactory.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
            _jsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        }
    }
}

