/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;

public class TextUtil {
    private static final Pattern cntFilter = Pattern.compile("\\d+");
    private static final Log LOG = LogFactory.getLog(TextUtil.class);

    public static String getHtmlFromFile(String fname, String encoding) {
        File file = new File(fname);
        byte[] bytes = new byte[(int)file.length()];
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            in.readFully(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String string = null;
        try {
            string = new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return string;
    }

    public static String filterInteger(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            if (StringUtils.isNumeric((String)string)) {
                return string;
            }
            Matcher matcher = cntFilter.matcher(string);
            if (matcher.find()) {
                string = matcher.group(0);
                return string;
            }
        }
        return null;
    }

    public static byte[] balanceTag(byte[] data, String charset) {
        try {
            String page = new String(data, charset);
            page = Jsoup.parse((String)page).html();
            data = page.getBytes(charset);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return data;
    }

    public static boolean hasValue(String str) {
        return str != null && !str.trim().equals("");
    }

    public static String removeAllHtmlTags(String str) {
        if (TextUtil.hasValue(str)) {
            return str.replaceAll("<[^<>]+?>", "");
        }
        return "";
    }

    public static String getRegexGroup(String regex, String str, int id) {
        Pattern p;
        Matcher m;
        String resultStr = "";
        if (TextUtil.hasValue(str) && (m = (p = Pattern.compile(regex)).matcher(str)).find()) {
            resultStr = m.group(id);
        }
        return resultStr;
    }

    public static String getRegexGroup(Pattern p, String str, int id) {
        Matcher m;
        String resultStr = "";
        if (TextUtil.hasValue(str) && (m = p.matcher(str)).find()) {
            resultStr = m.group(id);
        }
        return resultStr;
    }

    public static String getstr(String source, String regex) {
        String tmp = null;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(source);
        if (m.find()) {
            tmp = m.group(1);
        }
        return tmp;
    }

    public static void addMinMaxPriceTest(String price) {
        String[] priceArray = price.split("-");
        System.out.println(priceArray[0].trim().replaceAll(":", "").replaceAll("\uffe5", ""));
        System.err.println(priceArray[1].trim().replaceAll(":", "").replaceAll("\uffe5", ""));
    }

    public static String getMaxCommonStr(String s1, String s2) {
        int j;
        int i;
        char[] str2;
        int len2;
        char[] str1 = s1.toCharArray();
        int len1 = str1.length;
        int maxLen = len1 > (len2 = (str2 = s2.toCharArray()).length) ? len1 : len2;
        int[] max = new int[maxLen];
        int[] maxIndex = new int[maxLen];
        int[] c = new int[maxLen];
        for (i = 0; i < len2; ++i) {
            block1: for (j = len1 - 1; j >= 0; --j) {
                int k;
                c[j] = str2[i] == str1[j] ? (i == 0 || j == 0 ? 1 : c[j - 1] + 1) : 0;
                if (c[j] > max[0]) {
                    max[0] = c[j];
                    maxIndex[0] = j;
                    for (k = 1; k < maxLen; ++k) {
                        max[k] = 0;
                        maxIndex[k] = 0;
                    }
                    continue;
                }
                if (c[j] != max[0]) continue;
                for (k = 1; k < maxLen; ++k) {
                    if (max[k] != 0) continue;
                    max[k] = c[j];
                    maxIndex[k] = j;
                    continue block1;
                }
            }
        }
        ArrayList<String> rss = new ArrayList<String>();
        for (j = 0; j < maxLen; ++j) {
            StringBuffer sb = new StringBuffer();
            if (max[j] <= 0) continue;
            for (i = maxIndex[j] - max[j] + 1; i <= maxIndex[j]; ++i) {
                sb.append(str1[i]);
            }
            rss.add(sb.toString());
        }
        if (rss.size() > 0) {
            return (String)rss.get(0);
        }
        return "";
    }

    public static void main(String[] args) {
        String s1 = "\u4ea7\u54c1\u540d\u79f0\uff1aSamsung/\u4e09\u661f UA65HU9800...";
        String s2 = "title=\"Samsung/\u4e09\u661f UA65HU9800J\"";
        String rs = TextUtil.getMaxCommonStr(s1, s2);
        System.out.println("rs:" + rs);
    }
}

