/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils.htmlcleaner;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XPatherException;

public class HtmlCleanerUtil {
    private static Logger log = Logger.getLogger(HtmlCleanerUtil.class);

    public static String getContentByTagNode(TagNode tagNode) {
        List tags = tagNode.getAllChildren();
        StringBuffer sb = new StringBuffer();
        for (BaseToken tag : tags) {
            if (!(tag instanceof ContentNode) || ((ContentNode)tag).getContent().trim().length() == 0) continue;
            sb.append(((ContentNode)tag).getContent());
        }
        return sb.toString();
    }

    public static List<String> getItemAttrFromList(TagNode node, String listXpath, String attrName) {
        int total = 0;
        String itemUrl = "";
        ArrayList<String> rs = new ArrayList<String>();
        try {
            Object[] as;
            for (Object o : as = node.evaluateXPath(listXpath)) {
                TagNode a = (TagNode)o;
                itemUrl = a.getAttributeByName(attrName);
                System.out.println(itemUrl);
                if (!itemUrl.startsWith("http:")) continue;
                ++total;
                rs.add(itemUrl);
            }
        }
        catch (XPatherException e) {
            e.printStackTrace();
        }
        log.info((Object)"");
        return rs;
    }

    public static void removeByTag(TagNode root, String tagType) {
        try {
            Object[] scripts = root.evaluateXPath(tagType);
            System.out.println("scripts size is " + scripts.length);
            for (Object obj : scripts) {
                ((TagNode)obj).removeFromTree();
            }
        }
        catch (XPatherException e) {
            e.printStackTrace();
        }
    }

    public static TagNode getTagnodeByXpath(TagNode node, String xpath) {
        Object[] objs = null;
        try {
            objs = node.evaluateXPath(xpath);
        }
        catch (XPatherException e) {
            e.printStackTrace();
        }
        if (objs.length == 0) {
            return null;
        }
        return (TagNode)objs[0];
    }

    public static String getValueByTagnode(TagNode node, String attrName) {
        if (node.getAttributeByName(attrName) != null) {
            return node.getAttributeByName(attrName);
        }
        return "";
    }

    public static String getValueByXpath(TagNode node, String xpath, String defaultValue, String attrName) {
        Object[] objs = null;
        try {
            objs = node.evaluateXPath(xpath);
        }
        catch (XPatherException e) {
            e.printStackTrace();
            return defaultValue;
        }
        if (objs.length == 0) {
            return defaultValue;
        }
        TagNode tag = (TagNode)objs[0];
        if ("text".equalsIgnoreCase(attrName)) {
            return tag.getText().toString().trim();
        }
        return tag.getAttributeByName(attrName).trim();
    }

    public static int getIntValueByXpath(TagNode node, String xpath, int defaultValue, String attrName) {
        String str = "";
        Object[] objs = null;
        try {
            objs = node.evaluateXPath(xpath);
        }
        catch (XPatherException e) {
            e.printStackTrace();
            return defaultValue;
        }
        if (objs.length == 0) {
            return defaultValue;
        }
        TagNode tag = (TagNode)objs[0];
        str = "text".equalsIgnoreCase(attrName) ? tag.getText().toString().trim() : tag.getAttributeByName(attrName).trim();
        int rs = 0;
        try {
            rs = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            rs = 0;
        }
        return rs;
    }
}

