/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils.httpclient;

import com.fuwenchao.utils.httpclient.BaseClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class MyCrawler {
    public static Logger log = Logger.getLogger(MyCrawler.class);
    public static int SO_TIMEOUT = 40000;
    public static int CONNECTION_TIMEOUT = 10000;
    public static String USER_AGENT = "\tMozilla/5.0 (Windows NT 6.1; WOW64; rv:30.0) Gecko/20100101 Firefox/30.0";
    public static String ACCEPT_LANG = "\tzh-cn,en-us;q=0.8,zh-tw;q=0.5,en;q=0.3";
    public static String ACCEPT_CHARSET = "utf-8, GBK, GB2312;q=0.7,*;q=0.7";
    private int socket_timeout = SO_TIMEOUT;
    private int connection_timeout = CONNECTION_TIMEOUT;
    private String user_agent = USER_AGENT;
    private String accept_lang = ACCEPT_LANG;
    private String accept_charset = ACCEPT_CHARSET;
    private String charSet;
    private DefaultHttpClient client;
    private long interval;
    private static final Map<String, String> skippedFormats = MyCrawler.initSkippedFormats();

    public MyCrawler() {
        this.client = new BaseClient().getClient();
    }

    public MyCrawler(DefaultHttpClient client) {
        this.client = client;
    }

    public String[] get(String url) {
        if (this.pre_filtered(url)) {
            return null;
        }
        String[] rs = this.get(url = this.clean(url), "", this.interval);
        if (rs == null || rs.length < 2) {
            return new String[0];
        }
        return rs;
    }

    public String[] getWithRedirectUrl(String url) {
        if (this.pre_filtered(url)) {
            return null;
        }
        url = this.clean(url);
        return this.get(url, "", this.interval);
    }

    public String get(String url, String lastUrl) {
        if (this.pre_filtered(url)) {
            return null;
        }
        String[] content = this.get(url = this.clean(url), lastUrl, this.interval);
        if (content != null) {
            return content[1];
        }
        return null;
    }

    public String[] get(String url, String lastUrl, long interval) {
        if (this.pre_filtered(url)) {
            return null;
        }
        String[] urlAndContent = null;
        try {
            urlAndContent = this.doGet(this.client, url, lastUrl, "");
            if (interval != 0L) {
                Thread.sleep(interval);
            }
        }
        catch (Exception e) {
            log.info((Object)("thread name is" + Thread.currentThread().getName() + ".the error ip is " + this.client.getParams().getParameter("http.route.local-address")));
            log.info((Object)("the error url is " + url));
            log.error((Object)e.getMessage());
            e.printStackTrace();
            e.printStackTrace(System.out);
            log.info((Object)("thread name is" + Thread.currentThread().getName() + ".the error url is " + url));
        }
        return urlAndContent;
    }

    public String[] get(String url, String lastUrl, String cookies) {
        if (this.pre_filtered(url)) {
            return null;
        }
        String[] urlAndContent = null;
        try {
            urlAndContent = this.doGet(this.client, url, lastUrl, cookies);
            if (this.interval != 0L) {
                Thread.sleep(this.interval);
            }
        }
        catch (Exception e) {
            log.info((Object)("thread name is" + Thread.currentThread().getName() + ".the error ip is " + this.client.getParams().getParameter("http.route.local-address")));
            log.info((Object)("the error url is " + url));
            log.error((Object)e.getMessage());
            e.printStackTrace();
            e.printStackTrace(System.out);
            log.info((Object)("thread name is" + Thread.currentThread().getName() + ".the error url is " + url));
        }
        return urlAndContent;
    }

    public String[] post(String url, List<NameValuePair> nvpairs, String referUrl) {
        if (this.pre_filtered(url)) {
            return null;
        }
        url = this.clean(url);
        String[] content = null;
        try {
            content = this.doPost(this.client, url, nvpairs, referUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    private String[] doPost(DefaultHttpClient client, String url, List<NameValuePair> nvpairs, String referUrl) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.getParams().setParameter("http.socket.timeout", (Object)this.socket_timeout);
        httpPost.setHeader("User-Agent", this.user_agent);
        httpPost.setHeader("Accept-Language", this.accept_lang);
        httpPost.setHeader("Accept-Charset", this.accept_charset);
        httpPost.setHeader("Referer", referUrl);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvpairs, "gbk"));
        String[] content = this.requestExecutor(client, (HttpRequestBase)httpPost);
        if (content != null && content.length >= 2) {
            return content;
        }
        return new String[0];
    }

    private String[] doGet(DefaultHttpClient client, String url, String lastUrl, String cookies) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        httpGet.getParams().setParameter("http.socket.timeout", (Object)this.socket_timeout);
        httpGet.setHeader("User-Agent", this.user_agent);
        httpGet.setHeader("Accept-Language", this.accept_lang);
        httpGet.setHeader("Accept-Charset", this.accept_charset);
        if (cookies != null && cookies.trim().length() != 0) {
            httpGet.setHeader("Cookie", cookies);
        }
        httpGet.setHeader("Referer", lastUrl);
        httpGet.setHeader("Accept-Encoding", "gzip, deflate");
        return this.requestExecutor(client, (HttpRequestBase)httpGet);
    }

    public synchronized void setHandlRedirect(boolean flag) {
        this.client.getParams().setParameter("http.protocol.handle-redirects", (Object)flag);
    }

    private String[] requestExecutor(DefaultHttpClient client, HttpRequestBase method) {
        client.getParams().setParameter("http.socket.timeout", (Object)this.socket_timeout);
        client.getParams().setParameter("http.connection.timeout", (Object)this.connection_timeout);
        String realUrl = "";
        String content = "";
        BasicHttpContext context = new BasicHttpContext();
        String cookieStr = "";
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)method, (HttpContext)context);
            log.debug((Object)("return status is :" + response.getStatusLine()));
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 302) {
                method.abort();
                this.client.getConnectionManager().closeIdleConnections(0L, TimeUnit.SECONDS);
                return null;
            }
            HttpEntity entity = response.getEntity();
            content = this.getContent(entity);
            cookieStr = MyCrawler.getCookie((HttpResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            method.abort();
            this.client.getConnectionManager().closeIdleConnections(0L, TimeUnit.SECONDS);
            log.info((Object)("the error url is " + method.getURI()));
            log.error((Object)(".the error ip is " + client.getParams().getParameter("http.route.local-address")));
            log.error((Object)e.getMessage());
            return null;
        }
        return new String[]{realUrl, content, cookieStr};
    }

    private static String getCookie(HttpResponse response) {
        String cookies = "";
        String temp = "";
        int count = 1;
        Header[] h = response.getAllHeaders();
        for (int i = 0; i < h.length; ++i) {
            if (!h[i].getName().contains("Set-Cookie")) continue;
            temp = h[i].getValue();
            cookies = count == 1 ? cookies + temp : cookies + ";" + temp;
            ++count;
        }
        return cookies;
    }

    private String getContent(HttpEntity entity) throws Exception {
        if (entity == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = EntityUtils.toByteArray((HttpEntity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.charSet = EntityUtils.getContentCharSet((HttpEntity)entity);
        entity.consumeContent();
        if (this.charSet == null || this.charSet.trim().equals("") || this.charSet.trim().equals("none")) {
            String regEx = null;
            regEx = "<(meta|\\?\\s?xml).*?(charset=|encoding=)\"?([\\w-]+)";
            Pattern p = Pattern.compile(regEx, 2);
            Matcher m = p.matcher(new String(bytes));
            this.charSet = m.find() && m.groupCount() == 3 ? m.group(3) : "utf-8";
        }
        if (this.charSet != null && this.charSet != "") {
            return new String(bytes, this.charSet);
        }
        return new String(bytes);
    }

    private boolean pre_filtered(String url) {
        if (url == null || url.trim().equals("")) {
            return true;
        }
        String fileType = this.getFileTypeFromUrl(url);
        return skippedFormats.containsKey(fileType);
    }

    private String clean(String url) {
        url = url.replaceAll("\\|", "%7C");
        return url;
    }

    public String getFileTypeFromUrl(String url) {
        String[] temp;
        String type = "";
        if (url.indexOf(63) > 0) {
            url = url.substring(0, url.indexOf(63));
        }
        if ((temp = url.split("\\.")).length > 1) {
            type = temp[temp.length - 1].toLowerCase();
        }
        return type;
    }

    private static Map<String, String> initSkippedFormats() {
        HashMap<String, String> formats = new HashMap<String, String>();
        formats.put("pdf", ".pdf");
        formats.put("doc", ".doc");
        formats.put("xls", ".xls");
        formats.put("ps", ".ps");
        formats.put("ppt", ".ppt");
        formats.put("rtf", ".rtf");
        return formats;
    }

    public String getCookieStr() {
        List cookies = this.client.getCookieStore().getCookies();
        StringBuffer sb = new StringBuffer();
        for (Cookie cookie : cookies) {
            sb.append(cookie.getName() + "=" + cookie.getValue() + ";");
        }
        return sb.toString();
    }

    public void setCookies(String url) {
        this.get(url);
    }

    public void setProxy(String ip, Integer port) {
        HttpHost proxy = new HttpHost(ip, port.intValue());
        this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    public void setLocalIp(String ip) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.client.getParams().setParameter("http.route.local-address", (Object)inetAddress);
    }

    public String getCharSet() {
        return this.charSet;
    }

    public int getSocket_timeout() {
        return this.socket_timeout;
    }

    public void setSocket_timeout(int socket_timeout) {
        this.socket_timeout = socket_timeout;
    }

    public int getConnection_timeout() {
        return this.connection_timeout;
    }

    public void setConnection_timeout(int connection_timeout) {
        this.connection_timeout = connection_timeout;
    }

    public String getUser_agent() {
        return this.user_agent;
    }

    public void setUser_agent(String user_agent) {
        this.user_agent = user_agent;
    }

    public String getAccept_lang() {
        return this.accept_lang;
    }

    public void setAccept_lang(String accept_lang) {
        this.accept_lang = accept_lang;
    }

    public String getAccept_charset() {
        return this.accept_charset;
    }

    public void setAccept_charset(String accept_charset) {
        this.accept_charset = accept_charset;
    }

    public List<Cookie> getCookies() {
        if (this.client == null) {
            return null;
        }
        return this.client.getCookieStore().getCookies();
    }

    public DefaultHttpClient getClient() {
        return this.client;
    }

    public void setClient(DefaultHttpClient client) {
        this.client = client;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedirectUrl(String url) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getParams().setParameter("http.socket.timeout", (Object)this.socket_timeout);
        httpclient.getParams().setParameter("http.connection.timeout", (Object)this.connection_timeout);
        BasicHttpContext localContext = new BasicHttpContext();
        HttpHead httpHead = new HttpHead(url);
        String rs = "";
        try {
            httpclient.execute((HttpUriRequest)httpHead, (HttpContext)localContext);
            HttpHost target = (HttpHost)localContext.getAttribute("http.target_host");
            HttpUriRequest req = (HttpUriRequest)localContext.getAttribute("http.request");
            String uri = req.getURI() == null ? "" : req.getURI().toString();
            log.info((Object)("Target host: " + target));
            log.info((Object)("Final request URI: " + req.getURI()));
            rs = target + uri;
            if (this.interval != 0L) {
                Thread.sleep(this.interval);
            }
        }
        catch (ClientProtocolException e) {
            log.info((Object)("current thread name is " + Thread.currentThread().getName() + ".the url is " + url + "."));
            e.printStackTrace();
        }
        catch (IOException e) {
            log.info((Object)("current thread name is " + Thread.currentThread().getName() + ".the url is " + url + "."));
            e.printStackTrace();
        }
        catch (Exception e) {
            log.info((Object)("current thread name is " + Thread.currentThread().getName() + ".the url is " + url + "."));
            e.printStackTrace();
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return rs;
    }

    private void setProxy(String workstation, String domain) {
        String proxyId = "172.19.6.223";
        int port = 8080;
        String username = "pdmptest";
        String passwd = "u*nx-Sz9";
        this.client.getCredentialsProvider().setCredentials(new AuthScope(proxyId, port), (Credentials)new NTCredentials(username, passwd, workstation, domain));
        HttpHost proxy = new HttpHost(proxyId, port);
        System.out.println("proxy:" + proxyId + " prot :" + port + " username:" + username + " passwd:" + passwd + " domain:" + domain);
        this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    public static void main(String[] args) {
        String url = "https://github.com/";
        String refer = "http://weibo.com";
        String cookie = "http://www.baidu.com";
        String html = new MyCrawler().get(url, refer, cookie)[1];
        System.out.println(html);
    }
}

