/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.visualTree.example;

import com.fuwenchao.visualTree.example.ButtonCellEditor;
import com.fuwenchao.visualTree.example.ButtonCellRenderer;
import com.fuwenchao.visualTree.example.DocsMgtRmi;
import com.fuwenchao.visualTree.example.DocsTreeTransferHanlder;
import com.fuwenchao.visualTree.example.VEachDir;
import com.fuwenchao.visualTree.example.VEachFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class InnerDocsMgt
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTable table;
    private JTree tree;
    private JLabel currentDirLabel;
    private JLabel totalFilesNumLabel;
    private List<VEachFile> docFils;
    private final int maxFilesAPage = 50;
    private JLabel curPageLabel;
    private int curPageNum = 0;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    InnerDocsMgt frame = new InnerDocsMgt();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public InnerDocsMgt() {
        this.setTitle("\u5185\u90e8\u8d44\u6599\u7ba1\u7406");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 450, 300);
        this.setSize(800, 600);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "West");
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{54, 0, 0, 0, 0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{31, 0, 0};
        gbl_panel.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblNewLabel = new JLabel("\u5185\u90e8\u8d44\u6599\u76ee\u5f55\u5217\u8868");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.gridwidth = 5;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        panel.add((Component)lblNewLabel, gbc_lblNewLabel);
        JButton button_4 = new JButton("\u4fdd\u5b58\u76ee\u5f55\u64cd\u4f5c");
        GridBagConstraints gbc_button_4 = new GridBagConstraints();
        gbc_button_4.insets = new Insets(0, 0, 5, 5);
        gbc_button_4.gridx = 5;
        gbc_button_4.gridy = 0;
        panel.add((Component)button_4, gbc_button_4);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.gridwidth = 7;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        panel.add((Component)scrollPane, gbc_scrollPane);
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("/");
        this.createNodes(top);
        this.tree = new JTree(top);
        scrollPane.setViewportView(this.tree);
        this.tree.setEditable(true);
        this.tree.setDragEnabled(true);
        this.setPopupMenu();
        try {
            this.tree.setTransferHandler(new DocsTreeTransferHanlder());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JPanel panel_1 = new JPanel();
        this.contentPane.add((Component)panel_1, "Center");
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{708, 0};
        gbl_panel_1.rowHeights = new int[]{556, 0};
        gbl_panel_1.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 0;
        panel_1.add((Component)tabbedPane, gbc_tabbedPane);
        JPanel panel_2 = new JPanel();
        tabbedPane.addTab("\u6587\u4ef6\u4e0e\u76ee\u5f55\u7ba1\u7406", null, panel_2, null);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{166, 59, 0, 0, 0, 0, 0};
        gbl_panel_2.rowHeights = new int[]{30, 0, 49, 0, 0, 0};
        gbl_panel_2.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        this.currentDirLabel = new JLabel("\u5f53\u524d\u76ee\u5f55\uff1aone->two->three");
        GridBagConstraints gbc_lblonetwothree = new GridBagConstraints();
        gbc_lblonetwothree.gridwidth = 6;
        gbc_lblonetwothree.anchor = 17;
        gbc_lblonetwothree.insets = new Insets(0, 0, 5, 0);
        gbc_lblonetwothree.gridx = 0;
        gbc_lblonetwothree.gridy = 0;
        panel_2.add((Component)this.currentDirLabel, gbc_lblonetwothree);
        JButton button_3 = new JButton("\u5168\u9009/\u5168\u4e0d\u9009");
        GridBagConstraints gbc_button_3 = new GridBagConstraints();
        gbc_button_3.insets = new Insets(0, 0, 5, 5);
        gbc_button_3.gridx = 3;
        gbc_button_3.gridy = 1;
        panel_2.add((Component)button_3, gbc_button_3);
        JButton button = new JButton("\u5220\u9664");
        GridBagConstraints gbc_button = new GridBagConstraints();
        gbc_button.insets = new Insets(0, 0, 5, 5);
        gbc_button.gridx = 4;
        gbc_button.gridy = 1;
        panel_2.add((Component)button, gbc_button);
        JButton button_1 = new JButton("\u79fb\u52a8\u5230");
        button_1.setToolTipText("\u8bf7\u5148\u9009\u62e9\u8981\u79fb\u52a8\u7684\u6587\u4ef6\uff0c\u7136\u540e\u518d\u9009\u62e9\u4e00\u4e2a\u5de6\u4fa7\u76ee\u5f55");
        GridBagConstraints gbc_button_1 = new GridBagConstraints();
        gbc_button_1.insets = new Insets(0, 0, 5, 0);
        gbc_button_1.gridx = 5;
        gbc_button_1.gridy = 1;
        panel_2.add((Component)button_1, gbc_button_1);
        JScrollPane scrollPane_1 = new JScrollPane();
        GridBagConstraints gbc_scrollPane_1 = new GridBagConstraints();
        gbc_scrollPane_1.gridwidth = 6;
        gbc_scrollPane_1.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane_1.fill = 1;
        gbc_scrollPane_1.gridx = 0;
        gbc_scrollPane_1.gridy = 2;
        panel_2.add((Component)scrollPane_1, gbc_scrollPane_1);
        String[] headNames = new String[]{"\u9009\u62e9", "\u6587\u4ef6\u540d", "\u5927\u5c0f\uff08KB\uff09", "\u6587\u4ef6\u65e5\u671f", "\u4f5c\u8005", "", "\u4e0b\u8f7d"};
        Object[][] tableDatas = new Object[50][7];
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < 7; ++j) {
                tableDatas[i][j] = null;
            }
        }
        this.table = new JTable(new DocsTableModel(headNames, tableDatas));
        this.table.getColumnModel().getColumn(0).setCellEditor(this.table.getDefaultEditor(Boolean.class));
        this.table.getColumnModel().getColumn(0).setCellRenderer(this.table.getDefaultRenderer(Boolean.class));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(38);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(206);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(53);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(134);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(58);
        this.table.getTableHeader().getColumnModel().getColumn(5).setMaxWidth(0);
        this.table.getTableHeader().getColumnModel().getColumn(5).setMinWidth(0);
        this.table.getTableHeader().getColumnModel().getColumn(5).setPreferredWidth(0);
        this.table.getTableHeader().getColumnModel().getColumn(5).setWidth(0);
        this.table.getColumnModel().getColumn(6).setCellRenderer(new ButtonCellRenderer());
        this.table.getColumnModel().getColumn(6).setCellEditor(new ButtonCellEditor(this.table));
        scrollPane_1.setViewportView(this.table);
        this.totalFilesNumLabel = new JLabel("\u6587\u4ef6\u603b\u6570\uff1a0");
        GridBagConstraints gbc_totalFilesNumLabel = new GridBagConstraints();
        gbc_totalFilesNumLabel.anchor = 17;
        gbc_totalFilesNumLabel.insets = new Insets(0, 0, 0, 5);
        gbc_totalFilesNumLabel.gridx = 0;
        gbc_totalFilesNumLabel.gridy = 4;
        panel_2.add((Component)this.totalFilesNumLabel, gbc_totalFilesNumLabel);
        this.curPageLabel = new JLabel("\u5f53\u524d\u9875\u6570\uff1a0| \u603b\u9875\u6570\uff1a0");
        GridBagConstraints gbc_curPageLabel = new GridBagConstraints();
        gbc_curPageLabel.gridwidth = 2;
        gbc_curPageLabel.insets = new Insets(0, 0, 0, 5);
        gbc_curPageLabel.gridx = 2;
        gbc_curPageLabel.gridy = 4;
        panel_2.add((Component)this.curPageLabel, gbc_curPageLabel);
        JButton btnNewButton = new JButton("\u4e0a\u4e00\u9875");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerDocsMgt.this.prePage();
            }
        });
        GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
        gbc_btnNewButton.insets = new Insets(0, 0, 0, 5);
        gbc_btnNewButton.gridx = 4;
        gbc_btnNewButton.gridy = 4;
        panel_2.add((Component)btnNewButton, gbc_btnNewButton);
        JButton button_2 = new JButton("\u4e0b\u4e00\u9875");
        button_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerDocsMgt.this.nextPage();
            }
        });
        GridBagConstraints gbc_button_2 = new GridBagConstraints();
        gbc_button_2.gridx = 5;
        gbc_button_2.gridy = 4;
        panel_2.add((Component)button_2, gbc_button_2);
        JPanel panel_3 = new JPanel();
        tabbedPane.addTab("\u7f16\u8f91\u6587\u6863", null, panel_3, null);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{0};
        gbl_panel_3.rowHeights = new int[]{0};
        gbl_panel_3.columnWeights = new double[]{Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{Double.MIN_VALUE};
        panel_3.setLayout(gbl_panel_3);
    }

    private void createNodes(DefaultMutableTreeNode top) {
        List<DefaultMutableTreeNode> nodes = DocsMgtRmi.getINS().getFirstLevelDirs();
        for (DefaultMutableTreeNode one : nodes) {
            top.add(one);
        }
    }

    public void setPopupMenu() {
        final JPopupMenu pop = new JPopupMenu();
        pop.add(new AbstractAction("\u6dfb\u52a0\u5b50\u76ee\u5f55"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Tree Add");
            }
        });
        pop.add(new AbstractAction("\u5220\u9664\u76ee\u5f55"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Delete");
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isMetaDown()) {
                    pop.show(InnerDocsMgt.this.tree, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 1) {
                    VEachDir eDir = (VEachDir)InnerDocsMgt.this.getSelectedNode().getUserObject();
                    InnerDocsMgt.this.docFils = DocsMgtRmi.getINS().getFilesViaDirid(eDir.getDirId());
                    int filesNum = InnerDocsMgt.this.docFils.size();
                    InnerDocsMgt.this.currentDirLabel.setText("\u5f53\u524d\u76ee\u5f55\uff1aone->two->three,=>DirID:" + eDir.getDirId());
                    InnerDocsMgt.this.totalFilesNumLabel.setText("\u6587\u4ef6\u603b\u6570\uff1a" + filesNum);
                    int maxNum = Math.min(50, filesNum);
                    if (filesNum <= 50) {
                        InnerDocsMgt.this.curPageLabel.setText("\u5f53\u524d\u9875\u6570\uff1a 1 | \u603b\u9875\u6570\uff1a 1");
                    } else {
                        int totalNum = filesNum / 50;
                        if (totalNum * 50 < filesNum) {
                            ++totalNum;
                        }
                        InnerDocsMgt.this.curPageLabel.setText("\u5f53\u524d\u9875\u6570\uff1a 1 | \u603b\u9875\u6570\uff1a " + totalNum);
                    }
                    InnerDocsMgt.this.curPageNum = 0;
                    InnerDocsMgt.this.setDocTableValues(InnerDocsMgt.this.docFils.subList(0, maxNum));
                }
            }
        });
    }

    public void prePage() {
        if (this.curPageNum <= 0) {
            return;
        }
        int filesNum = this.docFils.size();
        --this.curPageNum;
        int totalPage = filesNum / 50;
        if (totalPage * 50 < filesNum) {
            ++totalPage;
        }
        this.curPageLabel.setText("\u5f53\u524d\u9875\u6570\uff1a " + (this.curPageNum + 1) + " | \u603b\u9875\u6570\uff1a " + totalPage);
        this.setDocTableValues(this.docFils.subList(this.curPageNum * 50, Math.min((this.curPageNum + 1) * 50, filesNum)));
    }

    public void nextPage() {
        int filesNum = this.docFils.size();
        int totalPage = filesNum / 50;
        if (totalPage * 50 < filesNum) {
            ++totalPage;
        }
        if (this.curPageNum >= totalPage - 1) {
            return;
        }
        ++this.curPageNum;
        this.setDocTableValues(this.docFils.subList(this.curPageNum * 50, Math.min((this.curPageNum + 1) * 50, filesNum)));
        this.curPageLabel.setText("\u5f53\u524d\u9875\u6570\uff1a " + (this.curPageNum + 1) + " | \u603b\u9875\u6570\uff1a " + totalPage);
    }

    public void setDocTableValues(List<VEachFile> subDocs) {
        int i;
        for (i = 0; i < subDocs.size(); ++i) {
            this.table.getModel().setValueAt(false, i, 0);
            this.table.getModel().setValueAt(subDocs.get(i).getFileName(), i, 1);
            this.table.getModel().setValueAt(subDocs.get(i).getFileSize(), i, 2);
            this.table.getModel().setValueAt(subDocs.get(i).getFileDate().toLocaleString(), i, 3);
            this.table.getModel().setValueAt(subDocs.get(i).getFileAuthor(), i, 4);
            this.table.getModel().setValueAt(subDocs.get(i).getFilePath(), i, 5);
        }
        if (subDocs.size() < 50) {
            while (i < 50) {
                this.table.getModel().setValueAt(false, i, 0);
                this.table.getModel().setValueAt(null, i, 1);
                this.table.getModel().setValueAt(null, i, 2);
                this.table.getModel().setValueAt(null, i, 3);
                this.table.getModel().setValueAt(null, i, 4);
                this.table.getModel().setValueAt(null, i, 5);
                ++i;
            }
        }
        this.table.updateUI();
        this.table.repaint();
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    class DocsTableModel
    extends AbstractTableModel {
        private String[] headName;
        private Object[][] obj;
        private Class[] columnTypes = new Class[]{Boolean.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class};

        public DocsTableModel() {
        }

        public DocsTableModel(String[] headName, Object[][] obj) {
            this();
            this.headName = headName;
            this.obj = obj;
        }

        @Override
        public int getColumnCount() {
            return this.headName.length;
        }

        @Override
        public int getRowCount() {
            return this.obj.length;
        }

        @Override
        public Object getValueAt(int r, int c) {
            return this.obj[r][c];
        }

        @Override
        public String getColumnName(int c) {
            return this.headName[c];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex].getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.obj[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

