/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.zookeeper;

import com.fuwenchao.utils.JsonUtil;
import java.util.Arrays;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class DataMonitor
implements Watcher,
AsyncCallback.StatCallback {
    ZooKeeper zk;
    String znode;
    Watcher chainedWatcher;
    boolean dead;
    DataMonitorListener listener;
    byte[] prevData;

    public DataMonitor(ZooKeeper zk, String znode, Watcher chainedWatcher, DataMonitorListener listener) {
        this.zk = zk;
        this.znode = znode;
        this.chainedWatcher = chainedWatcher;
        this.listener = listener;
        zk.exists(znode, true, (AsyncCallback.StatCallback)this, null);
    }

    public void process(WatchedEvent event) {
        System.out.println("datamonitor process!");
        String path = event.getPath();
        System.err.println("datamonitor process path:" + path + ".enent:" + JsonUtil.toJSONString(event) + ".eventtype:" + event.getType());
        if (event.getType() == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case SyncConnected: {
                    break;
                }
                case Expired: {
                    this.dead = true;
                    this.listener.closing(-112);
                }
            }
        } else if (path != null && path.equals(this.znode)) {
            this.zk.exists(this.znode, true, (AsyncCallback.StatCallback)this, null);
        }
        if (this.chainedWatcher != null) {
            this.chainedWatcher.process(event);
        }
    }

    public void processResult(int rc, String path, Object ctx, Stat stat) {
        boolean exists;
        System.out.println("datamonitor processresult!stat:" + JsonUtil.toJSONString(stat) + ".path:" + path + ".ctx:" + JsonUtil.toJSONString(ctx) + ".rc:" + rc);
        switch (rc) {
            case 0: {
                exists = true;
                break;
            }
            case -101: {
                exists = false;
                break;
            }
            case -112: 
            case -102: {
                this.dead = true;
                this.listener.closing(rc);
                return;
            }
            default: {
                this.zk.exists(this.znode, true, (AsyncCallback.StatCallback)this, null);
                return;
            }
        }
        byte[] b = null;
        if (exists) {
            try {
                b = this.zk.getData(this.znode, false, null);
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (b == null && b != this.prevData || b != null && !Arrays.equals(this.prevData, b)) {
            this.listener.exists(b);
            this.prevData = b;
        }
    }

    public static interface DataMonitorListener {
        public void exists(byte[] var1);

        public void closing(int var1);
    }
}

