/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.tmptask.crawlOpenhub.parser;

import com.bfd.crawler.tmptask.Iparser;
import com.bfd.crawler.tmptask.Task;
import com.bfd.crawler.utils.htmlcleaner.HtmlCleanerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XPatherException;

public class ProjectParser
implements Iparser {
    private static Logger log = Logger.getLogger(ProjectParser.class);

    @Override
    public Map<String, Object> parseHtml(String html, Task task, Map<String, Object> parseRs) {
        this.parseOpenhub(html, parseRs);
        return null;
    }

    private void parseOpenhub(String html, Map<String, Object> parseRs) {
        HtmlCleaner cleaner = new HtmlCleaner();
        TagNode root = cleaner.clean(html);
        String commits = HtmlCleanerUtil.getContentByXpath(root, "//div[@class='indent']/a[1]", "", "text");
        String contributors = HtmlCleanerUtil.getContentByXpath(root, "//div[@class='indent']/a[2]", "", "text");
        String highActivity = HtmlCleanerUtil.getContentByXpath(root, "//div[@class='thirtyfive_project_activity_text']", "", "text");
        String useNum = HtmlCleanerUtil.getContentByXpath(root, "//div[@class='use_count']/a[1]", "", "text");
        List<Map<String, String>> language = ProjectParser.getLanguage(root);
        parseRs.put("commits", commits.replace("commits", "").replace(",", ""));
        parseRs.put("contributors", contributors.replace("contributors", "").replace(",", ""));
        parseRs.put("highActivity", highActivity);
        parseRs.put("useNum", useNum);
        parseRs.put("language", language);
        ProjectParser.getActivity(root, parseRs);
    }

    private static void getActivity(TagNode root, Map<String, Object> rs) {
        String commits30 = HtmlCleanerUtil.getContentByXpath(root, "//ul[@id='thirty_day_summary']/li[1]/big[1]", "", "text");
        String contribute30 = HtmlCleanerUtil.getContentByXpath(root, "//ul[@id='thirty_day_summary']/li[2]/big[1]", "", "text");
        String commits12 = HtmlCleanerUtil.getContentByXpath(root, "//ul[@class='unstyled nutshell']/li[1]/big[1]", "", "text");
        String contributorss12 = HtmlCleanerUtil.getContentByXpath(root, "//ul[@class='unstyled nutshell']/li[2]/big[1]", "", "text");
        rs.put("commits30", commits30);
        rs.put("contribute30", contribute30);
        rs.put("commits12", commits12);
        rs.put("contributorss12", contributorss12);
        log.info((Object)"");
    }

    private static List<Map<String, String>> getLanguage(TagNode root) {
        ArrayList<Map<String, String>> rs = new ArrayList<Map<String, String>>();
        try {
            Object[] objs;
            for (Object obj : objs = root.evaluateXPath("//tr[@class='float_left']")) {
                HashMap<String, String> map = new HashMap<String, String>();
                TagNode tag = (TagNode)obj;
                String language = HtmlCleanerUtil.getContentByXpath(tag, "td[1]/a[1]", "", "text");
                String percent = HtmlCleanerUtil.getContentByXpath(tag, "td[2]/span[1]/span[1]", "", "text");
                if (language.length() == 0) {
                    map.put("language", "other");
                } else {
                    map.put("language", language);
                }
                map.put("percent", percent.trim());
                rs.add(map);
            }
        }
        catch (XPatherException e) {
            e.printStackTrace();
        }
        return rs;
    }
}

