/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.tmptask.newscrawl;

import com.bfd.crawler.tmptask.Task;
import com.bfd.crawler.tmptask.newscrawl.BaseNewsThread;
import com.bfd.crawler.tmptask.newscrawl.NewsThread;
import com.bfd.crawler.tmptask.newscrawl.entity.LoadConfig;
import com.bfd.crawler.tmptask.newscrawl.entity.WebsiteConfig;
import com.bfd.crawler.utils.ConfigUtils;
import com.bfd.crawler.utils.JsonUtils;
import java.io.File;
import org.apache.log4j.Logger;

public class StartNewsCrawl {
    private static Logger LOG = Logger.getLogger(StartNewsCrawl.class);

    public static void addAllStartUrlFromConfigFile() {
        LOG.info((Object)("websiteConfig:" + JsonUtils.toJSONString(LoadConfig.websites)));
        for (int i = 0; i < LoadConfig.websites.size(); ++i) {
            WebsiteConfig website = LoadConfig.websites.get(i);
            Task tmpTask = new Task();
            tmpTask.setCid(website.getCid());
            tmpTask.setHost(website.getHost());
            tmpTask.setUrl(website.getStartUrl());
            tmpTask.setUrlRule(website.getUrlRule());
            tmpTask.setTimeRule(website.getTimeRule());
            LOG.info((Object)("add task:" + JsonUtils.toJSONString(tmpTask)));
            BaseNewsThread.queue.putTask(tmpTask);
        }
    }

    public static void addStartRulFromArgs(String[] args) {
        Task tmpTask = new Task();
        tmpTask.setCid(args[1]);
        tmpTask.setHost(args[2]);
        tmpTask.setUrl(args[3]);
        tmpTask.setUrlRule(args[4]);
        if (args.length > 5) {
            tmpTask.setTimeRule(args[5]);
        }
        BaseNewsThread.queue.putTask(tmpTask);
    }

    public static void main(String[] args) {
        ConfigUtils.getInstance().readFile(new File("../etc/poc_config"));
        BaseNewsThread.topic = ConfigUtils.getInstance().getProp("news_kafka_topic", "poc_news");
        LOG.info((Object)("poc_news:" + BaseNewsThread.topic));
        StartNewsCrawl.addAllStartUrlFromConfigFile();
        LOG.info((Object)("args:" + JsonUtils.toJSONString(args)));
        if (args.length >= 5) {
            StartNewsCrawl.addStartRulFromArgs(args);
        }
        int threadNum = 0;
        threadNum = args.length >= 1 ? Integer.parseInt(args[0]) : 20;
        LOG.info((Object)("threadNum : " + threadNum));
        for (int i = 0; i < threadNum; ++i) {
            new Thread(new NewsThread()).start();
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.currentThread();
            Thread.sleep(1800000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (true) {
            if (BaseNewsThread.queue.getQueueSize() == 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1800000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (BaseNewsThread.queue.getQueueSize() != 0L) continue;
            System.exit(0);
        }
    }
}

