/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.tmptask.newscrawl.formatTime;

import com.bfd.crawler.tmptask.newscrawl.formatTime.TimeRegexRule;
import com.bfd.crawler.utils.MyDateUtil;
import com.bfd.crawler.utils.MyStringUtil;
import com.bfd.crawler.utils.ParserException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FormatTimeCommon {
    public static String formatTimeFacade(String dateStr) {
        String rs = "";
        rs = FormatTimeCommon.formatRule2(dateStr);
        if (rs.trim().length() > 0) {
            return rs;
        }
        rs = FormatTimeCommon.formatRule3(dateStr);
        if (rs.trim().length() > 0) {
            return rs;
        }
        rs = FormatTimeCommon.formatRule4(dateStr);
        if (rs.trim().length() > 0) {
            return rs;
        }
        return dateStr;
    }

    public static String formatRule2(String dateStr) {
        String rs = "";
        try {
            rs = MyStringUtil.getRegexGroup(TimeRegexRule.getTimeregex, dateStr, 1);
            if (rs.trim().length() > 0) {
                return rs;
            }
            rs = MyStringUtil.getRegexGroup(TimeRegexRule.getTimeregex2, dateStr, 1);
            if (rs.trim().length() > 0) {
                return rs;
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String formatRule3(String dateStr) {
        String date = "";
        try {
            date = MyStringUtil.getRegexGroup("((\\d+)\\s*\u5e74)?(\\d+)\\s*\u6708(\\d+)\\s*\u65e5", dateStr, 2) + "-" + MyStringUtil.getRegexGroup("((\\d+)\\s*\u5e74)?(\\d+)\\s*\u6708(\\d+)\\s*\u65e5", dateStr, 3) + "-" + MyStringUtil.getRegexGroup("((\\d+)\\s*\u5e74)?(\\d+)\\s*\u6708(\\d+)\\s*\u65e5", dateStr, 4);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String formatRule4(String datestr) {
        String month = TimeRegexRule.isContainEnglishMonth(datestr);
        if (month.trim().length() == 0) {
            return "";
        }
        String day = "";
        String year = "";
        try {
            day = MyStringUtil.getRegexGroup(TimeRegexRule.englishdate1, datestr, 1);
            year = MyStringUtil.getRegexGroup(TimeRegexRule.englishdate1, datestr, 2);
        }
        catch (ParserException e1) {
            e1.printStackTrace();
        }
        String date = "";
        if (day.trim().length() != 0 && year.trim().length() != 0) {
            datestr = day + " " + month + " " + year;
            SimpleDateFormat sdf2 = new SimpleDateFormat("d MMM yyyy", Locale.ENGLISH);
            try {
                Date datelong = sdf2.parse(datestr);
                date = MyDateUtil.getStr(datelong, "yyyy-MM-dd");
                System.out.println(datelong);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            return "";
        }
        return date;
    }

    public static void main(String[] args) {
        String str = "Posted Apr 30  2015 by ";
        String rs = FormatTimeCommon.formatRule4(str);
        System.out.println(rs);
    }
}

