/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DataHelper {
    private static final Log LOG = LogFactory.getLog(DataHelper.class);
    private static final byte[] _hexChars = "0123456789abcdef".getBytes();

    public static byte[] readFromFile(String filename) {
        File file = new File(filename);
        byte[] bytes = new byte[(int)file.length()];
        try {
            FileInputStream fis = new FileInputStream(file);
            fis.read(bytes);
            return bytes;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String calcMD5(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return DataHelper.toHexString(md.digest(data.getBytes()));
        }
        catch (Exception x) {
            LOG.warn((Object)("calc MD5 error, msg:" + x.getMessage()));
            return "";
        }
    }

    public static String toHexString(byte[] b) {
        StringBuffer s = new StringBuffer(2 * b.length);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            s.append((char)_hexChars[v >> 4]);
            s.append((char)_hexChars[v & 0xF]);
        }
        return s.toString();
    }

    public static String zipAndEncode(String data, String charset) throws Exception {
        return DataHelper.encodeBase64(DataHelper.zipData(data.getBytes(charset)));
    }

    public static byte[] unzipAndDecode(String data) throws DataFormatException, IOException {
        return DataHelper.unzipData(DataHelper.decodeBase64(data));
    }

    public static byte[] decodeBase64(String data) throws IOException {
        BASE64Decoder decoder = new BASE64Decoder();
        return decoder.decodeBuffer(data);
    }

    public static String encodeBase64(byte[] data) throws IOException {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static int hash(String str, int size) {
        String md5 = DataHelper.calcMD5(str);
        String head = md5.substring(0, 4);
        return Integer.parseInt(head, 16) % size;
    }

    public static byte[] unzipData(byte[] data) throws DataFormatException {
        Inflater _infl = new Inflater();
        _infl.setInput(data);
        int storelen = 0;
        int ileft = 0;
        byte[] buf = new byte[data.length << 3];
        byte[] tmpbuf = null;
        storelen += _infl.inflate(buf);
        ileft = _infl.getRemaining();
        if (ileft > 0) {
            tmpbuf = new byte[data.length << 1];
        }
        while (ileft > 0) {
            int isize = _infl.inflate(tmpbuf);
            ileft = _infl.getRemaining();
            byte[] dstbuf = new byte[storelen + isize];
            System.arraycopy(buf, 0, dstbuf, 0, buf.length);
            System.arraycopy(tmpbuf, 0, dstbuf, buf.length, isize);
            buf = dstbuf;
            storelen += isize;
        }
        _infl.end();
        if (storelen == buf.length) {
            return buf;
        }
        byte[] btret = new byte[storelen];
        System.arraycopy(buf, 0, btret, 0, storelen);
        return btret;
    }

    public static byte[] zipData(byte[] data) throws Exception {
        Deflater _zipper = new Deflater(1);
        _zipper.setInput(data);
        _zipper.finish();
        byte[] buf = new byte[data.length];
        int isize = _zipper.deflate(buf);
        if (isize > 0) {
            if (isize < buf.length) {
                byte[] btret = new byte[isize];
                System.arraycopy(buf, 0, btret, 0, isize);
                return btret;
            }
            return buf;
        }
        return null;
    }

    public static String decode(String data) {
        byte[] bt = data.getBytes();
        byte[] btres = new byte[bt.length];
        int i = 0;
        int j = 0;
        i = 0;
        j = 0;
        while (j < bt.length) {
            if ((bt[j] & 0xFC) == 192) {
                btres[i] = (byte)((bt[j] & 3) << 6 | bt[j + 1] & 0x3F);
                j += 2;
            } else {
                btres[i] = bt[j++];
            }
            ++i;
        }
        try {
            return new String(btres, 0, i, "utf8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.info((Object)("decode data exception, data: " + data + "\n error msg:" + e.getMessage()));
            return data;
        }
    }
}

