/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import com.bfd.crawler.utils.JsonUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class GetAllIps {
    public static final String ipRegex = "((([1-9]?|1\\d)\\d|2([0-4]\\d|5[0-5]))\\.){3}(([1-9]?|1\\d)\\d|2([0-4]\\d|5[0-5]))";

    public static List<String> getAllIps() {
        ArrayList<String> rs = new ArrayList<String>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            try {
                if (ni.isLoopback() || ni.isVirtual()) {
                    continue;
                }
            }
            catch (SocketException e1) {
                e1.printStackTrace();
            }
            Enumeration<InetAddress> ips = ni.getInetAddresses();
            while (ips.hasMoreElements()) {
                String ipstr = ips.nextElement().getHostAddress();
                if (!ipstr.matches(ipRegex)) continue;
                System.out.println(ipstr);
                rs.add(ipstr);
            }
        }
        return rs;
    }

    public static void main(String[] args) throws SocketException {
        List<String> ips = GetAllIps.getAllIps();
        System.out.println("---------------------");
        System.out.println(JsonUtils.toJSONString(ips));
    }
}

