/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.crawler.httpclient43.manager.crawler;

import com.bfd.crawler.utils.crawler.httpclient43.pojos.ProxyPojo;
import com.bfd.crawler.utils.crawler.httpclient43.utils.LoginConfigUtil;
import com.bfd.crawler.utils.crawler.httpclient43.utils.SystemParas;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientPojoManager {
    public static PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    public static int pool_current = 0;
    public static int pool_size = 0;
    public static List<HttpClientPojo> httpClientPojoList = null;
    public static HttpClientPojo httpClientPojo;
    public static RequestConfig default_requestConfig;

    public static void init() {
        httpClientPojoList = new LinkedList<HttpClientPojo>();
        if ("1".equals(LoginConfigUtil.getValueByKey("proxy_open"))) {
            pool_size = SystemParas.proxyList.size();
            for (ProxyPojo proxyPojo : SystemParas.proxyList) {
                httpClientPojoList.add(new HttpClientPojo(proxyPojo));
            }
        }
        connectionManager.setMaxTotal(100);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        httpClientPojo = new HttpClientPojo(httpClient);
        RequestConfig.Builder config_builder = RequestConfig.custom();
        config_builder.setSocketTimeout(SystemParas.http_connection_timeout);
        config_builder.setConnectTimeout(SystemParas.http_read_timeout);
        default_requestConfig = config_builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHttpClientPojo(HttpClientPojo clientPojo) {
        Class<HttpClientPojoManager> clazz = HttpClientPojoManager.class;
        synchronized (HttpClientPojoManager.class) {
            httpClientPojoList.remove(clientPojo);
            --pool_size;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientPojo getHttpClientPojo() {
        Class<HttpClientPojoManager> clazz = HttpClientPojoManager.class;
        synchronized (HttpClientPojoManager.class) {
            if ("1".equals(LoginConfigUtil.getValueByKey("proxy_open"))) {
                if (pool_current >= pool_size) {
                    pool_current = 0;
                    if (SystemParas.proxy_self) {
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return httpClientPojo;
                    }
                }
                HttpClientPojo temp_httpClientPojo = httpClientPojoList.get(pool_current);
                ++pool_current;
                // ** MonitorExit[var0] (shouldn't be in output)
                return temp_httpClientPojo;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClientPojo;
        }
    }

    public static void main(String[] args) {
    }

    static {
        default_requestConfig = null;
        HttpClientPojoManager.init();
    }

    public static class HttpClientPojo {
        private HttpHost proxy;
        private RequestConfig requestConfig;
        private CloseableHttpClient httpClient;
        private ProxyPojo proxyPojo;

        public String toString() {
            return "proxy=" + this.proxy + ",httpClient=" + this.httpClient + "";
        }

        public RequestConfig getRequestConfig() {
            return this.requestConfig;
        }

        public void setRequestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
        }

        public HttpHost getProxy() {
            return this.proxy;
        }

        public void setProxy(HttpHost proxy) {
            this.proxy = proxy;
        }

        public CloseableHttpClient getHttpClient() {
            return this.httpClient;
        }

        public void setHttpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public ProxyPojo getProxyPojo() {
            return this.proxyPojo;
        }

        public void setProxyPojo(ProxyPojo proxyPojo) {
            this.proxyPojo = proxyPojo;
        }

        private HttpClientPojo(ProxyPojo proxyPojo) {
            if (proxyPojo == null || !proxyPojo.isAuthEnable()) {
                this.proxy = null;
                this.httpClient = HttpClients.custom().build();
            } else {
                this.proxyPojo = proxyPojo;
                this.proxy = new HttpHost(proxyPojo.getIp(), proxyPojo.getPort());
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyPojo.getIp(), proxyPojo.getPort()), (Credentials)new UsernamePasswordCredentials(proxyPojo.getUsername(), proxyPojo.getPassword()));
                this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                RequestConfig.Builder config_builder = RequestConfig.custom();
                config_builder.setProxy(this.proxy);
                config_builder.setSocketTimeout(SystemParas.http_connection_timeout);
                config_builder.setConnectTimeout(SystemParas.http_read_timeout);
                this.requestConfig = config_builder.build();
            }
        }

        private HttpClientPojo() {
            this.httpClient = HttpClients.custom().build();
        }

        public HttpClientPojo(CloseableHttpClient httpclient) {
            this.httpClient = httpclient;
        }
    }
}

