/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.crawler.httpclient43.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class ReadConfigUtil {
    public InputStream in = null;
    public BufferedReader br = null;
    private Properties config = null;
    private String lineConfigTxt;

    public String getLineConfigTxt() {
        return this.lineConfigTxt;
    }

    public void setLineConfigTxt(String lineConfigTxt) {
        this.lineConfigTxt = lineConfigTxt;
    }

    public ReadConfigUtil(String configFilePath, boolean isConfig, boolean isClassPath) {
        if (isClassPath) {
            this.in = ReadConfigUtil.class.getClassLoader().getResourceAsStream(configFilePath);
        } else {
            try {
                this.in = new FileInputStream(new File(configFilePath));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.out.println("not found file path:" + configFilePath);
            }
        }
        try {
            if (isConfig) {
                this.config = new Properties();
                this.config.load(this.in);
                this.in.close();
            } else {
                this.br = new BufferedReader(new InputStreamReader(this.in));
                this.lineConfigTxt = this.getTextLines();
            }
        }
        catch (IOException e) {
            System.out.println("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u65f6\uff0c\u51fa\u73b0\u95ee\u9898!");
        }
    }

    public String getValue(String key) {
        try {
            String value = this.config.getProperty(key);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ConfigInfoError" + e.toString());
            return null;
        }
    }

    private String getTextLines() {
        StringBuilder sb = new StringBuilder();
        String temp = null;
        try {
            while ((temp = this.br.readLine()) != null) {
                if (temp.trim().length() <= 0 || temp.trim().startsWith("#")) continue;
                sb.append(temp);
                sb.append("\n");
            }
            this.br.close();
            this.in.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u8bfb\u53d6slaves\u6587\u4ef6\u65f6\uff0c\u51fa\u73b0\u95ee\u9898!");
            return sb.toString();
        }
    }

    public static void main(String[] args) {
    }
}

