// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The Ice locator interface. This interface is used by clients to
 * lookup adapters and objects. It is also used by servers to get the
 * locator registry proxy.
 * 
 * <p class="Note">The {@link Locator} interface is intended to be used by
 * Ice internals and by locator implementations. Regular user code
 * should not attempt to use any functionality of this interface
 * directly.
 * 
 **/
public interface LocatorPrx extends Ice.ObjectPrx
{
    /**
     * Find an object by identity and return its proxy.
     * 
     * @param id The identity.
     * 
     * @return The proxy, or null if the object is not active.
     * 
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     * 
     **/
    public Ice.ObjectPrx findObjectById(Identity id)
        throws ObjectNotFoundException;

    /**
     * Find an object by identity and return its proxy.
     * 
     * @param id The identity.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The proxy, or null if the object is not active.
     * 
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     * 
     **/
    public Ice.ObjectPrx findObjectById(Identity id, java.util.Map<String, String> __ctx)
        throws ObjectNotFoundException;

    /**
     * Find an object by identity and return its proxy.
     * 
     * @param id The identity.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id);

    /**
     * Find an object by identity and return its proxy.
     * 
     * @param id The identity.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, java.util.Map<String, String> __ctx);

    /**
     * Find an object by identity and return its proxy.
     * 
     * @param id The identity.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, Ice.Callback __cb);

    /**
     * Find an object by identity and return its proxy.
     * 
     * @param id The identity.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Find an object by identity and return its proxy.
     * 
     * @param id The identity.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, Callback_Locator_findObjectById __cb);

    /**
     * Find an object by identity and return its proxy.
     * 
     * @param id The identity.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, java.util.Map<String, String> __ctx, Callback_Locator_findObjectById __cb);

    /**
     * Find an object by identity and return its proxy.
     * 
     * @param __result The asynchronous result object.
     * @return The proxy, or null if the object is not active.
     * 
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     * 
     **/
    public Ice.ObjectPrx end_findObjectById(Ice.AsyncResult __result)
        throws ObjectNotFoundException;

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param id The adapter id.
     * 
     * @return The adapter proxy, or null if the adapter is not active.
     * 
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     * 
     **/
    public Ice.ObjectPrx findAdapterById(String id)
        throws AdapterNotFoundException;

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The adapter proxy, or null if the adapter is not active.
     * 
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     * 
     **/
    public Ice.ObjectPrx findAdapterById(String id, java.util.Map<String, String> __ctx)
        throws AdapterNotFoundException;

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param id The adapter id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id);

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, java.util.Map<String, String> __ctx);

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param id The adapter id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, Ice.Callback __cb);

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param id The adapter id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, Callback_Locator_findAdapterById __cb);

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, java.util.Map<String, String> __ctx, Callback_Locator_findAdapterById __cb);

    /**
     * Find an adapter by id and return its proxy (a dummy direct
     * proxy created by the adapter).
     * 
     * @param __result The asynchronous result object.
     * @return The adapter proxy, or null if the adapter is not active.
     * 
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     * 
     **/
    public Ice.ObjectPrx end_findAdapterById(Ice.AsyncResult __result)
        throws AdapterNotFoundException;

    /**
     * Get the locator registry.
     * 
     * @return The locator registry.
     * 
     **/
    public LocatorRegistryPrx getRegistry();

    /**
     * Get the locator registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The locator registry.
     * 
     **/
    public LocatorRegistryPrx getRegistry(java.util.Map<String, String> __ctx);

    /**
     * Get the locator registry.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry();

    /**
     * Get the locator registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(java.util.Map<String, String> __ctx);

    /**
     * Get the locator registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(Ice.Callback __cb);

    /**
     * Get the locator registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the locator registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(Callback_Locator_getRegistry __cb);

    /**
     * Get the locator registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(java.util.Map<String, String> __ctx, Callback_Locator_getRegistry __cb);

    /**
     * Get the locator registry.
     * 
     * @param __result The asynchronous result object.
     * @return The locator registry.
     * 
     **/
    public LocatorRegistryPrx end_getRegistry(Ice.AsyncResult __result);
}
