/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.kafka7;

import com.bfd.crawler.utils.ConfigUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.message.Message;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class KfkUtils {
    private static Logger LOG = Logger.getLogger(KfkUtils.class);

    public static Properties loadPropties() {
        ConfigUtils.getInstance().readFile(new File("../etc/kafka.properties"));
        Properties props = new Properties();
        String connect = ConfigUtils.getInstance().getProp("crawl.kfk.zkConnect", "172.18.1.115:21005,172.18.1.116:21005");
        if (StringUtils.isEmpty((CharSequence)connect)) {
            System.out.println("error no zkpath");
        }
        LOG.info((Object)("metadata.broker.list:" + connect));
        props.put("metadata.broker.list", connect);
        props.put("serializer.class", ConfigUtils.getInstance().getProp("crawl.kfk.kafka.serializer", "kafka.serializer.StringEncoder"));
        props.put("zk.sessiontimeout.ms", ConfigUtils.getInstance().getProp("crawl.kfk.zk.sessiontimeout.ms", "50000"));
        props.put("connect.timeout.ms", ConfigUtils.getInstance().getProp("crawl.kfk.connectionTimeOut", "50000"));
        props.put("zk.connectiontimeout.ms", ConfigUtils.getInstance().getProp("crawl.kfk.zk.connectiontimeout.ms", "50000"));
        return props;
    }

    public static String getMessage(Message message) {
        ByteBuffer buffer = message.payload();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes);
    }
}

