/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.config.util;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class CrawlMonitor
implements Watcher {
    private static Log LOG = LogFactory.getLog(CrawlMonitor.class);
    private ZooKeeper zk = null;
    private ICrawlMonitor client = null;
    private String rootName = "";
    private String connectString = "";
    private String monitorNode = "";

    private CrawlMonitor(ICrawlMonitor im, Map<String, String> params, CrawlService service) {
        this.client = im;
        this.checkArgs(params);
        String serviceName = this.getServiceName(service);
        if (serviceName == null) {
            throw new RuntimeException("serviceName is null");
        }
        this.monitorNode = String.valueOf(this.rootName) + "/monitor/" + serviceName;
        LOG.info((Object)("monitorNode is :" + this.monitorNode));
        this.init();
    }

    private ZooKeeper init() {
        final CountDownLatch connectionLatch = new CountDownLatch(1);
        try {
            this.zk = new ZooKeeper(this.connectString, 2000, new Watcher(){

                public void process(WatchedEvent event) {
                    Watcher.Event.KeeperState stat = event.getState();
                    if (stat == Watcher.Event.KeeperState.SyncConnected) {
                        connectionLatch.countDown();
                    }
                }
            });
        }
        catch (IOException e) {
            LOG.error((Object)"ZookeeperUtil:zk init process IO's problems", (Throwable)e);
            System.exit(0);
        }
        catch (Throwable e) {
            LOG.error((Object)"Fail to init zk instance", e);
            System.exit(0);
        }
        try {
            connectionLatch.await();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"ZookeeperUtil:zk init Interrupted problems", (Throwable)e);
            System.exit(0);
        }
        LOG.info((Object)"monitor zk is start...");
        return this.zk;
    }

    private String getServiceName(CrawlService service) {
        switch (service) {
            case SCHEDULE: {
                return "schedule";
            }
            case DISPATCH: {
                return "dispatch";
            }
            case WRITETASK: {
                return "writetask";
            }
            case DOWNLOAD: {
                return "download";
            }
            case PARSE: {
                return "parse";
            }
            case SAVE: {
                return "save";
            }
            case LOGINMANAGER: {
                return "loginmanager";
            }
            case FLOWQUOTA: {
                return "flowquota";
            }
            case KFK: {
                return "kfk";
            }
        }
        return null;
    }

    private void checkArgs(Map<String, String> params) {
        this.connectString = params.get("zkAddress");
        if (this.connectString == null || this.connectString.length() == 0) {
            throw new RuntimeException("zkAddress is empty");
        }
        this.rootName = params.get("zkRootName");
        if (this.rootName == null || this.rootName.length() == 0) {
            throw new RuntimeException("zkRootName is empty");
        }
        if (!this.rootName.startsWith("/")) {
            throw new RuntimeException("zkRootName must start with '/',your input is " + this.rootName);
        }
    }

    public static CrawlMonitor getInstance(Map<String, String> params, ICrawlMonitor client, CrawlService service) {
        return new CrawlMonitor(client, params, service);
    }

    public static CrawlMonitor getInstance(Map<String, String> params, ICrawlMonitor client, CrawlService service, Log log) {
        LOG = log;
        return new CrawlMonitor(client, params, service);
    }

    public boolean startMonitor() {
        if (this.zk == null) {
            this.zk = this.init();
        }
        byte[] data = null;
        try {
            data = this.zk.getData(this.monitorNode, (Watcher)this, null);
        }
        catch (KeeperException e) {
            LOG.error((Object)("fail to monitor ,the nodePath is " + this.monitorNode), (Throwable)e);
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.startMonitor();
        }
        catch (InterruptedException e) {
            LOG.error((Object)("fail to monitor ,the nodePath is " + this.monitorNode), (Throwable)e);
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.startMonitor();
        }
        LOG.info((Object)("data is " + (data == null ? "empty" : new String(data))));
        data = null;
        return true;
    }

    public void process(WatchedEvent arg) {
        String nodePath = arg.getPath();
        Watcher.Event.KeeperState ks = arg.getState();
        Watcher.Event.EventType type = arg.getType();
        LOG.info((Object)("monitor:" + arg.toString()));
        if (ks == Watcher.Event.KeeperState.SyncConnected && type == Watcher.Event.EventType.NodeDataChanged) {
            LOG.info((Object)("Node data change!nodePath is " + nodePath));
            if (this.zk == null) {
                this.zk = this.init();
            }
            byte[] data = null;
            try {
                data = this.zk.getData(this.monitorNode, (Watcher)this, null);
            }
            catch (KeeperException e) {
                LOG.error((Object)("fail to process ,the nodePath is " + nodePath), (Throwable)e);
                this.sleep(2);
                this.startMonitor();
            }
            catch (InterruptedException e) {
                LOG.error((Object)("fail to process ,the nodePath is " + nodePath), (Throwable)e);
                this.sleep(2);
                this.startMonitor();
            }
            this.client.changes(new String(data));
            data = null;
        }
    }

    private void sleep(int seconds) {
        if (seconds < 1) {
            return;
        }
        try {
            Thread.currentThread();
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static enum CrawlService {
        SCHEDULE,
        DISPATCH,
        WRITETASK,
        DOWNLOAD,
        FLOWQUOTA,
        PARSE,
        SAVE,
        KFK,
        LOGINMANAGER;

    }

    public static interface ICrawlMonitor {
        public void changes(String var1);
    }
}

