// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Observer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The node observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * nodes.
 * 
 **/
public interface _NodeObserverOperations
{
    /**
     * The <tt>nodeInit</tt> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * 
     * @param nodes The current state of the nodes.
     * 
     * @param __current The Current object for the invocation.
     **/
    void nodeInit(NodeDynamicInfo[] nodes, Ice.Current __current);

    /**
     * The <tt>nodeUp</tt> operation is called to notify an observer that a node
     * came up.
     * 
     * @param node The node state.
     * 
     * @param __current The Current object for the invocation.
     **/
    void nodeUp(NodeDynamicInfo node, Ice.Current __current);

    /**
     * The <tt>nodeDown</tt> operation is called to notify an observer that a node
     * went down.
     * 
     * @param name The node name.
     * 
     * @param __current The Current object for the invocation.
     **/
    void nodeDown(String name, Ice.Current __current);

    /**
     * The <tt>updateServer</tt> operation is called to notify an observer that
     * the state of a server changed.
     * 
     * @param node The node hosting the server.
     * 
     * @param updatedInfo The new server state.
     * 
     * @param __current The Current object for the invocation.
     **/
    void updateServer(String node, ServerDynamicInfo updatedInfo, Ice.Current __current);

    /**
     * The <tt>updateAdapter</tt> operation is called to notify an observer that
     * the state of an adapter changed.
     * 
     * @param node The node hosting the adapter.
     * 
     * @param updatedInfo The new adapter state.
     * 
     * @param __current The Current object for the invocation.
     **/
    void updateAdapter(String node, AdapterDynamicInfo updatedInfo, Ice.Current __current);
}
