// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Observer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * This interface allows applications to monitor IceGrid well-known objects.
 * 
 **/
public interface _ObjectObserverOperations
{
    /**
     * <tt>objectInit</tt> is called after the registration of
     * an observer to indicate the state of the registry.
     * 
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * 
     * @param __current The Current object for the invocation.
     **/
    void objectInit(ObjectInfo[] objects, Ice.Current __current);

    /**
     * The <tt>objectAdded</tt> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * 
     * @param info The details of the added object.
     * 
     * @param __current The Current object for the invocation.
     **/
    void objectAdded(ObjectInfo info, Ice.Current __current);

    /**
     * <tt>objectUpdated</tt> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * 
     * @param info The details of the updated object.
     * 
     * @param __current The Current object for the invocation.
     **/
    void objectUpdated(ObjectInfo info, Ice.Current __current);

    /**
     * <tt>objectRemoved</tt> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * 
     * @param id The identity of the removed object.
     * 
     * @param __current The Current object for the invocation.
     **/
    void objectRemoved(Ice.Identity id, Ice.Current __current);
}
