// **********************************************************************
//
// Copyright (c) 2003-2009 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.3.1

package bfd.alarm.sms;

public final class MessengerPrxHelper extends Ice.ObjectPrxHelperBase implements MessengerPrx
{
    public int
    sendMsg(String msg, String business, String group)
    {
        return sendMsg(msg, business, group, null, false);
    }

    public int
    sendMsg(String msg, String business, String group, java.util.Map<String, String> __ctx)
    {
        return sendMsg(msg, business, group, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private int
    sendMsg(String msg, String business, String group, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("sendMsg");
                __delBase = __getDelegate(false);
                _MessengerDel __del = (_MessengerDel)__delBase;
                return __del.sendMsg(msg, business, group, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex, null);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public int
    sendMsgWithTitle(String mailTitle, String msg, String business, String group)
    {
        return sendMsgWithTitle(mailTitle, msg, business, group, null, false);
    }

    public int
    sendMsgWithTitle(String mailTitle, String msg, String business, String group, java.util.Map<String, String> __ctx)
    {
        return sendMsgWithTitle(mailTitle, msg, business, group, __ctx, true);
    }

    @SuppressWarnings("unchecked")
    private int
    sendMsgWithTitle(String mailTitle, String msg, String business, String group, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("sendMsgWithTitle");
                __delBase = __getDelegate(false);
                _MessengerDel __del = (_MessengerDel)__delBase;
                return __del.sendMsgWithTitle(mailTitle, msg, business, group, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex, null);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    public static MessengerPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        MessengerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (MessengerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::bfd::alarm::sms::Messenger"))
                {
                    MessengerPrxHelper __h = new MessengerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static MessengerPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        MessengerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (MessengerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::bfd::alarm::sms::Messenger", __ctx))
                {
                    MessengerPrxHelper __h = new MessengerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static MessengerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        MessengerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::bfd::alarm::sms::Messenger"))
                {
                    MessengerPrxHelper __h = new MessengerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static MessengerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        MessengerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::bfd::alarm::sms::Messenger", __ctx))
                {
                    MessengerPrxHelper __h = new MessengerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static MessengerPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        MessengerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (MessengerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                MessengerPrxHelper __h = new MessengerPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static MessengerPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        MessengerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            MessengerPrxHelper __h = new MessengerPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _MessengerDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _MessengerDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, MessengerPrx v)
    {
        __os.writeProxy(v);
    }

    public static MessengerPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            MessengerPrxHelper result = new MessengerPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
