/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.elasti.producer;

import com.bfd.crawler.elasti.utils.ESClientFactory;
import com.bfd.crawler.elasti.utils.JsonUtils;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerProcess {
    private String indexName;
    private RestHighLevelClient restClient;
    private String indexType;
    private int importEsNum = 0;

    public ProducerProcess(String indexName, String indexType, ESClientFactory eSClientFactory) {
        this.indexName = indexName;
        this.indexType = indexType;
        this.restClient = eSClientFactory.getHighLevelClient();
    }

    public void createManyDates(Vector<String> dataJsons) {
        Vector<String> datas = null;
        try {
            BulkRequest bulkRequest = new BulkRequest();
            if (dataJsons.size() > 0) {
                datas = new Vector<String>(dataJsons);
                dataJsons.clear();
                for (String datam : datas) {
                    Map dataMap = (Map)JsonUtils.parseObject(datam);
                    String id = dataMap.get("_id_").toString();
                    IndexRequest indexRequest = new IndexRequest(this.indexName, this.indexType, id);
                    if (!StringUtils.isNotBlank((CharSequence)datam)) continue;
                    indexRequest.source(datam, XContentType.JSON);
                    bulkRequest.add(indexRequest);
                }
                this.restClient.bulk(bulkRequest, new Header[0]);
                this.importEsNum += datas.size();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addData(String json) {
        try {
            if (StringUtils.isNotBlank((CharSequence)json)) {
                Map dataMap = (Map)JsonUtils.parseObject(json);
                String id = dataMap.get("_id_").toString();
                IndexRequest indexRequest = new IndexRequest(this.indexName, "docs", id);
                indexRequest.source(json, XContentType.JSON);
                this.restClient.index(indexRequest, new Header[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTotalImportEsNum() {
        return this.importEsNum;
    }
}

