/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.elasti.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtils {
    private static final Log log = LogFactory.getLog(JsonUtils.class);
    private static JsonFactory _jsonFactory = null;

    public static String toJSONString(Object object) {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        try {
            om.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
            return om.writeValueAsString(object);
        }
        catch (Exception e) {
            log.warn((Object)"to json string exception, will use fastjson to parse", (Throwable)e);
            return null;
        }
    }

    public static Object parseObject(String str) throws Exception {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        return om.readValue(str.getBytes(), Object.class);
    }

    public static Object parseObjectNoException(String str) {
        Object o = null;
        try {
            o = JsonUtils.parseObject(str);
        }
        catch (Exception e) {
            log.error((Object)("parse str to  json error" + str), (Throwable)e);
            o = null;
        }
        return o;
    }

    public static Map<String, Object> parseMapNoException(String str) {
        Object o = null;
        try {
            o = JsonUtils.parseObject(str);
        }
        catch (Exception e) {
            log.error((Object)("parse str to  json error" + str), (Throwable)e);
            o = null;
            return null;
        }
        Map m = null;
        try {
            m = (Map)o;
        }
        catch (Exception e) {
            log.error((Object)("parse jsonobject to  map error" + m), (Throwable)e);
            return null;
        }
        return m;
    }

    public static Object parse(String str) throws Exception {
        return JsonUtils.parseObject(str);
    }

    public static List<Object> parseArray(String str) throws Exception {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        return (List)om.readValue(str.getBytes(), Object.class);
    }

    static {
        if (_jsonFactory == null) {
            _jsonFactory = new JsonFactory();
            _jsonFactory.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
            _jsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        }
    }
}

