/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdht;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import org.csource.common.MyException;
import org.csource.fastdht.ClientGlobal;
import org.csource.fastdht.KeyInfo;
import org.csource.fastdht.ObjectInfo;
import org.csource.fastdht.ProtoCommon;
import org.csource.fastdht.ServerGroup;
import org.csource.fastdht.ServerInfo;

public class FastDHTClient {
    protected ServerGroup serverGroup;
    protected byte status;

    public FastDHTClient(ServerGroup serverGroup) {
        this.serverGroup = serverGroup;
    }

    public FastDHTClient(boolean bMultiThread) {
        this.serverGroup = bMultiThread ? (ServerGroup)ClientGlobal.g_server_group.clone() : ClientGlobal.g_server_group;
    }

    public void close() {
        this.serverGroup.closeAll();
    }

    public byte getErrorCode() {
        return this.status;
    }

    public int set(KeyInfo keyInfo, String value) throws UnsupportedEncodingException, MyException {
        return this.set(keyInfo, value.getBytes(ClientGlobal.g_charset), 0);
    }

    public int set(KeyInfo keyInfo, byte[] value) throws UnsupportedEncodingException, MyException {
        return this.set(keyInfo, value, 0);
    }

    public int set(KeyInfo keyInfo, String value, int expires) throws UnsupportedEncodingException, MyException {
        return this.set(keyInfo, value.getBytes(ClientGlobal.g_charset), expires);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(KeyInfo keyInfo, byte[] value, int expires) throws UnsupportedEncodingException, MyException {
        ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
        header.key_hash_code = keyInfo.getHashCode();
        ServerInfo server = this.serverGroup.getServer(header.key_hash_code);
        if (server == null) {
            this.status = (byte)2;
            return this.status;
        }
        try {
            header.body_len = keyInfo.getPackLength() + 4 + value.length;
            header.cmd = (byte)11;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = (int)(System.currentTimeMillis() / 1000L);
            header.expires = expires;
            byte[] bsPackage = new byte[19 + header.body_len];
            ProtoCommon.packHeader(header, bsPackage);
            int offset = keyInfo.pack(bsPackage, 19);
            ProtoCommon.int2buff(value.length, bsPackage, offset);
            System.arraycopy(value, 0, bsPackage, offset += 4, value.length);
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, 0L);
            byte by = this.status = pkgInfo.header.status;
            return by;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            byte by = this.status = (byte)5;
            return by;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(KeyInfo keyInfo) throws MyException {
        ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
        header.key_hash_code = keyInfo.getHashCode();
        ServerInfo server = this.serverGroup.getServer(header.key_hash_code);
        if (server == null) {
            this.status = (byte)2;
            return this.status;
        }
        try {
            header.body_len = keyInfo.getPackLength();
            header.cmd = (byte)14;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = (int)(System.currentTimeMillis() / 1000L);
            header.expires = 0;
            byte[] bsPackage = new byte[19 + header.body_len];
            ProtoCommon.packHeader(header, bsPackage);
            keyInfo.pack(bsPackage, 19);
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, 0L);
            byte by = this.status = pkgInfo.header.status;
            return by;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            byte by = this.status = (byte)5;
            return by;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }

    public String get(KeyInfo keyInfo) throws UnsupportedEncodingException, MyException {
        return this.get(keyInfo, -1);
    }

    public String get(KeyInfo keyInfo, int expires) throws UnsupportedEncodingException, MyException {
        byte[] bs = this.getBytes(keyInfo, expires);
        if (bs == null) {
            return null;
        }
        return new String(bs, ClientGlobal.g_charset);
    }

    public byte[] getBytes(KeyInfo keyInfo) throws UnsupportedEncodingException, MyException {
        return this.getBytes(keyInfo, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(KeyInfo keyInfo, int expires) throws MyException {
        ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
        header.key_hash_code = keyInfo.getHashCode();
        ServerInfo server = this.serverGroup.getServer(header.key_hash_code);
        if (server == null) {
            this.status = (byte)2;
            return null;
        }
        try {
            header.body_len = keyInfo.getPackLength();
            header.cmd = (byte)13;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = (int)(System.currentTimeMillis() / 1000L);
            header.expires = expires;
            byte[] bsPackage = new byte[19 + header.body_len];
            ProtoCommon.packHeader(header, bsPackage);
            keyInfo.pack(bsPackage, 19);
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, -1L);
            this.status = pkgInfo.header.status;
            if (this.status != 0) {
                byte[] byArray = null;
                return byArray;
            }
            if (pkgInfo.body.length < 4) {
                this.serverGroup.forceClose(server);
                this.status = (byte)22;
                byte[] byArray = null;
                return byArray;
            }
            int value_len = ProtoCommon.buff2int(pkgInfo.body, 0);
            if (value_len + 4 != pkgInfo.body.length) {
                this.serverGroup.forceClose(server);
                this.status = (byte)22;
                byte[] byArray = null;
                return byArray;
            }
            byte[] result = new byte[value_len];
            System.arraycopy(pkgInfo.body, 4, result, 0, value_len);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            this.status = (byte)5;
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }

    public Long inc(KeyInfo keyInfo, int increment) throws MyException {
        return this.inc(keyInfo, increment, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long inc(KeyInfo keyInfo, int increment, int expires) throws MyException {
        ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
        header.key_hash_code = keyInfo.getHashCode();
        ServerInfo server = this.serverGroup.getServer(header.key_hash_code);
        if (server == null) {
            this.status = (byte)2;
            return null;
        }
        try {
            header.body_len = keyInfo.getPackLength() + 4;
            header.cmd = (byte)12;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = (int)(System.currentTimeMillis() / 1000L);
            header.expires = expires;
            byte[] bsPackage = new byte[19 + header.body_len];
            ProtoCommon.packHeader(header, bsPackage);
            int offset = keyInfo.pack(bsPackage, 19);
            ProtoCommon.int2buff(increment, bsPackage, offset);
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, -1L);
            this.status = pkgInfo.header.status;
            if (this.status != 0) {
                Long l = null;
                return l;
            }
            if (pkgInfo.body.length < 4) {
                this.serverGroup.forceClose(server);
                this.status = (byte)22;
                Long l = null;
                return l;
            }
            int value_len = ProtoCommon.buff2int(pkgInfo.body, 0);
            if (value_len + 4 != pkgInfo.body.length) {
                this.serverGroup.forceClose(server);
                this.status = (byte)22;
                Long l = null;
                return l;
            }
            String value = new String(pkgInfo.body, 4, value_len);
            Long l = new Long(value);
            return l;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            this.status = (byte)5;
            Long l = null;
            return l;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }

    private int parseBatchUpdate(int src_key_count, ServerInfo server, ProtoCommon.PkgInfo pkgInfo, Map failKeys) throws UnsupportedEncodingException {
        this.status = pkgInfo.header.status;
        if (this.status != 0) {
            return -1 * this.status;
        }
        if (pkgInfo.body.length < 8 + 5 * src_key_count) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " body length: " + pkgInfo.body.length + " < " + (8 + 5 * src_key_count));
            this.serverGroup.forceClose(server);
            this.status = (byte)22;
            return -1 * this.status;
        }
        int key_count = ProtoCommon.buff2int(pkgInfo.body, 0);
        if (key_count != src_key_count) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " key count: " + key_count + " != " + src_key_count);
            this.serverGroup.forceClose(server);
            this.status = (byte)22;
            return -1 * this.status;
        }
        int offset = 4;
        int success_count = ProtoCommon.buff2int(pkgInfo.body, offset);
        offset += 4;
        failKeys.clear();
        if (success_count == key_count) {
            return success_count;
        }
        for (int i = 0; i < key_count; ++i) {
            int key_len = ProtoCommon.buff2int(pkgInfo.body, offset);
            String key = new String(pkgInfo.body, offset += 4, key_len, ClientGlobal.g_charset);
            byte status = pkgInfo.body[offset + key_len];
            offset += key_len + 1;
            if (status == 0) continue;
            failKeys.put(key, new Integer(status));
        }
        return success_count;
    }

    public int batchSet(ObjectInfo objInfo, Map keyValues, Map failKeys) throws MyException {
        return this.batchSet(objInfo, keyValues, failKeys, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchSet(ObjectInfo objInfo, Map keyValues, Map failKeys, int expires) throws MyException {
        ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
        header.key_hash_code = objInfo.getHashCode();
        ServerInfo server = this.serverGroup.getServer(header.key_hash_code);
        if (server == null) {
            this.status = (byte)2;
            return -1 * this.status;
        }
        try {
            String value;
            String key;
            header.body_len = objInfo.getPackLength() + 4;
            header.cmd = (byte)15;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = (int)(System.currentTimeMillis() / 1000L);
            header.expires = expires;
            for (Map.Entry entry : keyValues.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                header.body_len += 8 + key.getBytes(ClientGlobal.g_charset).length + value.getBytes(ClientGlobal.g_charset).length;
            }
            byte[] bsPackage = new byte[19 + header.body_len];
            ProtoCommon.packHeader(header, bsPackage);
            int offset = objInfo.pack(bsPackage, 19);
            ProtoCommon.int2buff(keyValues.size(), bsPackage, offset);
            offset += 4;
            for (Map.Entry entry : keyValues.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                byte[] bsKey = key.getBytes(ClientGlobal.g_charset);
                byte[] bsValue = value.getBytes(ClientGlobal.g_charset);
                ProtoCommon.int2buff(bsKey.length, bsPackage, offset);
                System.arraycopy(bsKey, 0, bsPackage, offset += 4, bsKey.length);
                ProtoCommon.int2buff(bsValue.length, bsPackage, offset += bsKey.length);
                System.arraycopy(bsValue, 0, bsPackage, offset += 4, bsValue.length);
                offset += bsValue.length;
            }
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, -1L);
            int n = this.parseBatchUpdate(keyValues.size(), server, pkgInfo, failKeys);
            return n;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            this.status = (byte)5;
            int n = -1 * this.status;
            return n;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchDelete(ObjectInfo objInfo, String[] keys, Map failKeys) throws MyException {
        ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
        header.key_hash_code = objInfo.getHashCode();
        ServerInfo server = this.serverGroup.getServer(header.key_hash_code);
        if (server == null) {
            this.status = (byte)2;
            return -1 * this.status;
        }
        try {
            int i;
            header.body_len = objInfo.getPackLength() + 4;
            header.cmd = (byte)17;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = (int)(System.currentTimeMillis() / 1000L);
            header.expires = 0;
            for (i = 0; i < keys.length; ++i) {
                header.body_len += 4 + keys[i].getBytes(ClientGlobal.g_charset).length;
            }
            byte[] bsPackage = new byte[19 + header.body_len];
            ProtoCommon.packHeader(header, bsPackage);
            int offset = objInfo.pack(bsPackage, 19);
            ProtoCommon.int2buff(keys.length, bsPackage, offset);
            offset += 4;
            for (i = 0; i < keys.length; ++i) {
                byte[] bsKey = keys[i].getBytes(ClientGlobal.g_charset);
                ProtoCommon.int2buff(bsKey.length, bsPackage, offset);
                System.arraycopy(bsKey, 0, bsPackage, offset += 4, bsKey.length);
                offset += bsKey.length;
            }
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, -1L);
            int n = this.parseBatchUpdate(keys.length, server, pkgInfo, failKeys);
            return n;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            this.status = (byte)5;
            int n = -1 * this.status;
            return n;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }

    public Hashtable batchGet(ObjectInfo objInfo, String[] keys, Map failKeys) throws MyException {
        return this.batchGet(objInfo, keys, failKeys, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable batchGet(ObjectInfo objInfo, String[] keys, Map failKeys, int expires) throws MyException {
        ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
        header.key_hash_code = objInfo.getHashCode();
        ServerInfo server = this.serverGroup.getServer(header.key_hash_code);
        if (server == null) {
            this.status = (byte)2;
            return null;
        }
        try {
            int i;
            header.body_len = objInfo.getPackLength() + 4;
            header.cmd = (byte)16;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = (int)(System.currentTimeMillis() / 1000L);
            header.expires = expires;
            for (i = 0; i < keys.length; ++i) {
                header.body_len += 4 + keys[i].getBytes(ClientGlobal.g_charset).length;
            }
            byte[] bsPackage = new byte[19 + header.body_len];
            ProtoCommon.packHeader(header, bsPackage);
            int offset = objInfo.pack(bsPackage, 19);
            ProtoCommon.int2buff(keys.length, bsPackage, offset);
            offset += 4;
            for (i = 0; i < keys.length; ++i) {
                byte[] bsKey = keys[i].getBytes(ClientGlobal.g_charset);
                ProtoCommon.int2buff(bsKey.length, bsPackage, offset);
                System.arraycopy(bsKey, 0, bsPackage, offset += 4, bsKey.length);
                offset += bsKey.length;
            }
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, -1L);
            this.status = pkgInfo.header.status;
            if (this.status != 0) {
                Hashtable hashtable = null;
                return hashtable;
            }
            if (pkgInfo.body.length < 8 + 5 * keys.length) {
                System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " body length: " + pkgInfo.body.length + " < " + (8 + 5 * keys.length));
                this.serverGroup.forceClose(server);
                this.status = (byte)22;
                Hashtable hashtable = null;
                return hashtable;
            }
            int key_count = ProtoCommon.buff2int(pkgInfo.body, 0);
            if (key_count != keys.length) {
                System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " key count: " + key_count + " != " + keys.length);
                this.serverGroup.forceClose(server);
                this.status = (byte)22;
                Hashtable hashtable = null;
                return hashtable;
            }
            offset = 8;
            failKeys.clear();
            Hashtable<String, String> keyValues = new Hashtable<String, String>(2 * keys.length, 0.5f);
            for (i = 0; i < key_count; ++i) {
                int key_len = ProtoCommon.buff2int(pkgInfo.body, offset);
                String key = new String(pkgInfo.body, offset += 4, key_len, ClientGlobal.g_charset);
                byte status = pkgInfo.body[offset + key_len];
                offset += key_len + 1;
                if (status == 0) {
                    int value_len = ProtoCommon.buff2int(pkgInfo.body, offset);
                    String value = new String(pkgInfo.body, offset += 4, value_len, ClientGlobal.g_charset);
                    keyValues.put(key, value);
                    offset += value_len;
                    continue;
                }
                failKeys.put(key, new Integer(status));
            }
            Hashtable<String, String> hashtable = keyValues;
            return hashtable;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            this.status = (byte)5;
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable stat(int server_index) throws MyException {
        ServerInfo[] servers = this.serverGroup.getServers();
        ServerInfo server = servers[server_index];
        if (!this.serverGroup.connectServer(server)) {
            this.status = (byte)2;
            return null;
        }
        try {
            ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
            header.key_hash_code = 0;
            header.body_len = 0;
            header.cmd = (byte)18;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = (int)(System.currentTimeMillis() / 1000L);
            header.expires = 0;
            byte[] bsPackage = new byte[19];
            ProtoCommon.packHeader(header, bsPackage);
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, -1L);
            this.status = pkgInfo.header.status;
            if (this.status != 0) {
                Hashtable hashtable = null;
                return hashtable;
            }
            String szBody = new String(pkgInfo.body, ClientGlobal.g_charset);
            String[] rows = szBody.split("\n");
            Hashtable<String, String> keyValues = new Hashtable<String, String>(rows.length, 0.5f);
            for (int i = 0; i < rows.length; ++i) {
                String[] cols = rows[i].split("=");
                keyValues.put(cols[0], cols[1]);
            }
            Hashtable<String, String> hashtable = keyValues;
            return hashtable;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            this.status = (byte)5;
            Hashtable hashtable = null;
            return hashtable;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubKeys(ObjectInfo objInfo) throws UnsupportedEncodingException, MyException {
        ProtoCommon.PkgHeader header = new ProtoCommon.PkgHeader();
        header.key_hash_code = objInfo.getHashCode();
        ServerInfo server = this.serverGroup.getServer(header.key_hash_code);
        if (server == null) {
            this.status = (byte)2;
            return null;
        }
        try {
            header.body_len = objInfo.getPackLength();
            header.cmd = (byte)19;
            header.keep_alive = (byte)(this.serverGroup.keep_alive ? 1 : 0);
            header.timestamp = 0;
            header.expires = 0;
            byte[] bsPackage = new byte[19 + header.body_len];
            ProtoCommon.packHeader(header, bsPackage);
            objInfo.pack(bsPackage, 19);
            OutputStream out = server.sock.getOutputStream();
            out.write(bsPackage);
            ProtoCommon.PkgInfo pkgInfo = ProtoCommon.recvPackage(server.sock.getInputStream(), (byte)40, -1L);
            this.status = pkgInfo.header.status;
            if (this.status != 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String szSubKeys = new String(pkgInfo.body, ClientGlobal.g_charset);
            String[] stringArray = szSubKeys.split(ProtoCommon.FDHT_KEY_LIST_SEP_STR);
            return stringArray;
        }
        catch (IOException ex) {
            System.err.println("server " + server.address.getAddress().getHostAddress() + ":" + server.address.getPort() + " IOException, error msg: " + ex.getMessage());
            this.serverGroup.forceClose(server);
            this.status = (byte)5;
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.serverGroup.closeServer(server);
        }
    }
}

