/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdht;

import java.io.UnsupportedEncodingException;
import org.csource.common.Hash;
import org.csource.common.MyException;
import org.csource.fastdht.ClientGlobal;
import org.csource.fastdht.ProtoCommon;

public class KeyInfo {
    protected byte[] namespace;
    protected byte[] object_id;
    protected byte[] key;
    protected int namespace_len;
    protected int obj_id_len;
    protected int key_len;

    public KeyInfo(byte[] namespace, byte[] object_id, byte[] key) throws UnsupportedEncodingException, MyException {
        this.namespace = namespace;
        this.object_id = object_id;
        this.key = key;
        this.check();
    }

    public KeyInfo(String namespace, String object_id, String key) throws UnsupportedEncodingException, MyException {
        this.namespace = namespace.getBytes(ClientGlobal.g_charset);
        this.object_id = object_id.getBytes(ClientGlobal.g_charset);
        this.key = key.getBytes(ClientGlobal.g_charset);
        this.check();
    }

    private void check() throws MyException {
        this.namespace_len = this.namespace.length > 64 ? 64 : this.namespace.length;
        this.obj_id_len = this.object_id.length > 128 ? 128 : this.object_id.length;
        this.key_len = this.key.length > 128 ? 128 : this.key.length;
        if (this.namespace_len == 0 && this.obj_id_len != 0 || this.namespace_len != 0 && this.obj_id_len == 0) {
            throw new MyException("Invalid namespace length: " + this.namespace.length + " and object ID length: " + this.object_id.length);
        }
        if (this.key_len == 0) {
            throw new MyException("Invalid key length: " + this.key.length);
        }
    }

    public byte[] getNamespace() {
        return this.namespace;
    }

    public byte[] getObjectId() {
        return this.object_id;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getHashCode() {
        int true_key_len;
        byte[] hash_key;
        if (this.namespace_len == 0 && this.obj_id_len == 0) {
            hash_key = this.key;
            true_key_len = this.key_len;
        } else {
            hash_key = new byte[this.namespace_len + 1 + this.obj_id_len];
            System.arraycopy(this.namespace, 0, hash_key, 0, this.namespace_len);
            hash_key[this.namespace_len] = 1;
            System.arraycopy(this.object_id, 0, hash_key, this.namespace_len + 1, this.obj_id_len);
            true_key_len = hash_key.length;
        }
        int key_hash_code = Hash.Time33Hash(hash_key, 0, true_key_len);
        if (key_hash_code < 0) {
            key_hash_code &= Integer.MAX_VALUE;
        }
        return key_hash_code;
    }

    public int getPackLength() {
        return 12 + this.namespace_len + this.obj_id_len + this.key_len;
    }

    public int pack(byte[] bsPackage, int offset) {
        ProtoCommon.int2buff(this.namespace_len, bsPackage, offset);
        offset += 4;
        if (this.namespace_len > 0) {
            System.arraycopy(this.namespace, 0, bsPackage, offset, this.namespace_len);
            offset += this.namespace_len;
        }
        ProtoCommon.int2buff(this.obj_id_len, bsPackage, offset);
        offset += 4;
        if (this.obj_id_len > 0) {
            System.arraycopy(this.object_id, 0, bsPackage, offset, this.obj_id_len);
            offset += this.obj_id_len;
        }
        ProtoCommon.int2buff(this.key_len, bsPackage, offset);
        System.arraycopy(this.key, 0, bsPackage, offset += 4, this.key_len);
        return offset += this.key_len;
    }
}

