/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdht;

import java.util.Arrays;
import java.util.Hashtable;
import org.csource.fastdht.ClientGlobal;
import org.csource.fastdht.FastDHTClient;
import org.csource.fastdht.KeyInfo;
import org.csource.fastdht.ObjectInfo;

public class Test {
    private Test() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java org.csource.fastdht.Test <config filename>");
            return;
        }
        System.out.println("java.version=" + System.getProperty("java.version"));
        String conf_filename = args[0];
        try {
            ClientGlobal.init(conf_filename);
            System.out.println("network_timeout=" + ClientGlobal.g_network_timeout + "ms");
            System.out.println("charset=" + ClientGlobal.g_charset);
            ClientGlobal.g_server_group.print();
            FastDHTClient client = new FastDHTClient(false);
            try {
                KeyInfo keyInfo = new KeyInfo("bbs", "test", "username");
                System.out.println("set: " + client.set(keyInfo, "12345678901234"));
                System.out.println("get: " + client.get(keyInfo));
                System.out.println("inc: " + client.inc(keyInfo, 100));
                for (int i = 0; i < ClientGlobal.g_server_group.servers.length; ++i) {
                    Hashtable stats = client.stat(i);
                    if (stats == null) continue;
                    System.out.println("server=" + ClientGlobal.g_server_group.servers[i].address.getAddress().getHostAddress() + ":" + ClientGlobal.g_server_group.servers[i].address.getPort());
                    System.out.println(stats.toString());
                }
                ObjectInfo objInfo = new ObjectInfo(keyInfo.getNamespace(), keyInfo.getObjectId());
                System.out.println("sub keys: " + Arrays.toString(client.getSubKeys(objInfo)));
            }
            finally {
                client.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

