/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.xml;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.JsonGeneratorBase;
import org.codehaus.jackson.impl.JsonWriteContext;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.SerializedString;
import org.codehaus.jackson.xml.StaxUtil;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.Stax2WriterAdapter;

public class ToXmlGenerator
extends JsonGeneratorBase {
    protected final XMLStreamWriter2 _xmlWriter;
    protected final IOContext _ioContext;
    protected int _xmlFeatures;
    protected String _nextName = "unknown";

    public ToXmlGenerator(IOContext ctxt, int genericGeneratorFeatures, int xmlFeatures, ObjectCodec codec, XMLStreamWriter sw) {
        super(genericGeneratorFeatures, codec);
        this._xmlFeatures = xmlFeatures;
        this._ioContext = ctxt;
        this._xmlWriter = Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)sw);
    }

    public ToXmlGenerator enable(Feature f) {
        this._xmlFeatures |= f.getMask();
        return this;
    }

    public ToXmlGenerator disable(Feature f) {
        this._xmlFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._xmlFeatures & f.getMask()) != 0;
    }

    public ToXmlGenerator configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    protected final void _writeStartArray() throws IOException, JsonGenerationException {
        try {
            this._xmlWriter.writeStartElement(this._nextName);
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected void _writeEndArray() throws IOException, JsonGenerationException {
        try {
            this._xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected void _writeStartObject() throws IOException, JsonGenerationException {
        try {
            this._xmlWriter.writeStartElement(this._nextName);
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected void _writeEndObject() throws IOException, JsonGenerationException {
        try {
            this._xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected void _writeFieldName(String name, boolean commaBefore) throws IOException, JsonGenerationException {
        this._nextName = name;
    }

    protected void _writeFieldName(SerializedString name, boolean commaBefore) throws IOException, JsonGenerationException {
        this._writeFieldName(name.getValue(), commaBefore);
    }

    public void writeString(String text) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeCharacters(text);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeCharacters(text);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeCharacters(text, offset, len);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeCharacters(text, offset, len);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeRaw(String text) throws IOException, JsonGenerationException {
        try {
            this._xmlWriter.writeRaw(text);
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeRaw(String text, int offset, int len) throws IOException, JsonGenerationException {
        try {
            this._xmlWriter.writeRaw(text, offset, len);
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        try {
            this._xmlWriter.writeRaw(text, offset, len);
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.writeRaw(String.valueOf(c));
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeBinary(data, offset, len);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeBinary(data, offset, len);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeBoolean(state);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeEmptyElement(this._nextName);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeNumber(int i) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeInt(i);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeInt(i);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeLong(l);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeLong(l);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeDouble(d);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeDouble(d);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeFloat(f);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeFloat(f);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeDecimal(dec);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeDecimal(dec);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        try {
            if (this._nextName != null) {
                this._xmlWriter.writeStartElement(this._nextName);
                this._xmlWriter.writeInteger(v);
                this._xmlWriter.writeEndElement();
            } else {
                this._xmlWriter.writeInteger(v);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.writeString(encodedValue);
    }

    protected final void _verifyValueWrite(String typeMsg) throws IOException, JsonGenerationException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
    }

    public final void flush() throws IOException {
        try {
            this._xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext ctxt;
                if ((ctxt = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        try {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._xmlWriter.closeCompletely();
            } else {
                this._xmlWriter.close();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected void _releaseBuffers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        DUMMY(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

