/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.kafka7;

import com.bfd.crawler.utils.ConfigUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.I0Itec.zkclient.exception.ZkTimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KfkProducer {
    private static Logger LOG = Logger.getLogger(KfkProducer.class);
    private Producer<String, String> producter = null;
    private Properties props;
    private static KfkProducer kfkProducer;

    public static synchronized KfkProducer getInstance() {
        try {
            if (kfkProducer == null || KfkProducer.kfkProducer.producter == null) {
                kfkProducer = new KfkProducer();
            }
        }
        catch (ZkTimeoutException e) {
            e.printStackTrace();
            return KfkProducer.getInstance();
        }
        return kfkProducer;
    }

    private KfkProducer() {
        ConfigUtils.getInstance().readFile(new File("../etc/crawl-config.properties"));
        Properties props = new Properties();
        String connect = ConfigUtils.getInstance().getProp("crawl.kfk.metadata.broker.list", "172.18.1.115:21005,172.18.1.116:21005");
        if (StringUtils.isEmpty((String)connect)) {
            System.out.println("error no zkpath");
        }
        LOG.info((Object)("metadata.broker.list:" + connect));
        props.put("metadata.broker.list", connect);
        props.put("serializer.class", ConfigUtils.getInstance().getProp("crawl.kfk.kafka.serializer", "kafka.serializer.StringEncoder"));
        props.put("producer.type", "async");
        ProducerConfig config = new ProducerConfig(props);
        this.producter = new Producer(config);
        LOG.info((Object)("Connected zk successfully, metadata.broker.list=" + ConfigUtils.getInstance().getProp("metadata.broker.list")));
    }

    public boolean send(String topic, String message) {
        while (!this.executeSend(topic, message)) {
            LOG.warn((Object)"send message error!");
        }
        return true;
    }

    public boolean send(String topic, List<String> messages) {
        while (!this.executeSend(topic, messages)) {
            LOG.warn((Object)"send message error!");
        }
        return true;
    }

    public boolean executeSend(String topic, String message) {
        while (this.producter == null) {
            ProducerConfig config = new ProducerConfig(this.props);
            this.producter = new Producer(config);
        }
        if (StringUtils.isEmpty((String)topic) || StringUtils.isEmpty((String)message)) {
            LOG.warn((Object)"before send msg get topic or message -> null, ");
            return false;
        }
        LOG.info((Object)(" sending message to topic -> " + topic + ", " + " message:" + message + ",messagelength:" + message.getBytes().length));
        try {
            this.producter.send(new KeyedMessage(topic, (Object)message));
        }
        catch (Exception e) {
            LOG.warn((Object)"send data exception, err=", (Throwable)e);
            this.close();
            return false;
        }
        return true;
    }

    public boolean executeSend(String topic, List<String> messages) {
        if (messages == null || messages.size() == 0) {
            LOG.warn((Object)"before send msg get topic or message -> null, projName=");
            return false;
        }
        while (this.producter == null) {
            ProducerConfig config = new ProducerConfig(this.props);
            this.producter = new Producer(config);
        }
        try {
            for (String message : messages) {
                this.producter.send(new KeyedMessage(topic, (Object)message));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)(Thread.currentThread().getName() + ":topic is " + topic + ".message size is " + messages.size() + ".send data exception, err="), (Throwable)e);
            this.close();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.producter != null) {
            try {
                this.producter.close();
            }
            catch (Exception e) {
                LOG.warn((Object)"close producter exception, err=", (Throwable)e);
            }
            finally {
                this.producter = null;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        long begin = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            KfkProducer.getInstance().send("fuwenchaotest2", "\u5728\u63d0\u9ad8\u6548\u7387\u65b9\u9762\u505a\u4e86\u5f88\u5927\u52aa\u529b\u3002Kafka\u7684\u4e00\u4e2a\u4e3b\u8981\u4f7f\u7528\u573a\u666f\u662f\u5904\u7406\u7f51\u7ad9\u6d3b\u52a8\u65e5\u5fd7\uff0c\u541e\u5410\u91cf\u662f\u975e\u5e38\u5927\u7684\uff0c\u6bcf\u4e2a\u9875\u9762\u90fd\u4f1a\u4ea7\u751f\u597d\u591a\u6b21\u5199\u64cd\u4f5c\u3002\u8bfb\u65b9\u9762\uff0c\u5047\u8bbe\u6bcf\u4e2a\u6d88\u606f\u53ea\u88ab\u6d88\u8d39\u4e00\u6b21\uff0c\u8bfb\u7684\u91cf\u7684\u4e5f\u662f\u5f88\u5927\u7684\uff0cKafka\u4e5f\u5c3d\u91cf\u4f7f\u8bfb\u7684\u64cd\u4f5c\u66f4\u8f7b\u91cf\u5316\u3002");
        }
        long end = System.currentTimeMillis();
        System.out.println("begin:" + begin + ";end:" + end);
    }

    public static void main2(String[] args) {
        long begin = System.currentTimeMillis();
        long begin2 = new Date().getTime();
        System.out.println(begin + ":" + begin2);
        String str = "\u5728\u63d0\u9ad8\u6548\u7387\u65b9\u9762\u505a\u4e86\u5f88\u5927\u52aa\u529b\u3002Kafka\u7684\u4e00\u4e2a\u4e3b\u8981\u4f7f\u7528\u573a\u666f\u662f\u5904\u7406\u7f51\u7ad9\u6d3b\u52a8\u65e5\u5fd7\uff0c\u541e\u5410\u91cf\u662f\u975e\u5e38\u5927\u7684\uff0c\u6bcf\u4e2a\u9875\u9762\u90fd\u4f1a\u4ea7\u751f\u597d\u591a\u6b21\u5199\u64cd\u4f5c\u3002\u8bfb\u65b9\u9762\uff0c\u5047\u8bbe\u6bcf\u4e2a\u6d88\u606f\u53ea\u88ab\u6d88\u8d39\u4e00\u6b21\uff0c\u8bfb\u7684\u91cf\u7684\u4e5f\u662f\u5f88\u5927\u7684\uff0cKafka\u4e5f\u5c3d\u91cf\u4f7f\u8bfb\u7684\u64cd\u4f5c\u66f4\u8f7b\u91cf\u5316\u3002";
        System.out.println(str.length());
        System.out.println(str.getBytes().length);
    }
}

