/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.nlp.common.util.encryption;

import com.bfd.nlp.common.util.constants.Charsets;
import com.bfd.nlp.common.util.exception.Exceptions;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.zip.CRC32;
import org.apache.commons.lang3.Validate;

public class Digests {
    private static final String SHA1 = "SHA-1";
    private static final String MD5 = "MD5";
    private static SecureRandom random = new SecureRandom();

    public static byte[] sha1(byte[] input) {
        return Digests.digest(input, SHA1, null, 1);
    }

    public static byte[] sha1(String input) {
        return Digests.digest(input.getBytes(Charsets.UTF8), SHA1, null, 1);
    }

    public static byte[] sha1(String input, Charset charset) {
        return Digests.digest(input.getBytes(charset), SHA1, null, 1);
    }

    public static byte[] sha1(byte[] input, byte[] salt) {
        return Digests.digest(input, SHA1, salt, 1);
    }

    public static byte[] sha1(String input, byte[] salt) {
        return Digests.digest(input.getBytes(Charsets.UTF8), SHA1, salt, 1);
    }

    public static byte[] sha1(String input, Charset charset, byte[] salt) {
        return Digests.digest(input.getBytes(charset), SHA1, salt, 1);
    }

    public static byte[] sha1(byte[] input, byte[] salt, int iterations) {
        return Digests.digest(input, SHA1, salt, iterations);
    }

    public static byte[] sha1(String input, byte[] salt, int iterations) {
        return Digests.digest(input.getBytes(Charsets.UTF8), SHA1, salt, iterations);
    }

    public static byte[] sha1(String input, Charset charset, byte[] salt, int iterations) {
        return Digests.digest(input.getBytes(charset), SHA1, salt, iterations);
    }

    private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                digest.update(salt);
            }
            byte[] result = digest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] generateSalt(int numBytes) {
        Validate.isTrue((numBytes > 0 ? 1 : 0) != 0, (String)"numBytes argument must be a positive integer (1 or larger)", (long)numBytes);
        byte[] bytes = new byte[numBytes];
        random.nextBytes(bytes);
        return bytes;
    }

    public static byte[] md5(InputStream input) throws IOException {
        return Digests.digest(input, MD5);
    }

    public static byte[] sha1(InputStream input) throws IOException {
        return Digests.digest(input, SHA1);
    }

    private static byte[] digest(InputStream input, String algorithm) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            int bufferLength = 8192;
            byte[] buffer = new byte[bufferLength];
            int read = input.read(buffer, 0, bufferLength);
            while (read > -1) {
                messageDigest.update(buffer, 0, read);
                read = input.read(buffer, 0, bufferLength);
            }
            return messageDigest.digest();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static int crc32(byte[] input) {
        CRC32 crc32 = new CRC32();
        crc32.update(input);
        return (int)crc32.getValue();
    }

    public static int crc32(String input) {
        CRC32 crc32 = new CRC32();
        crc32.update(input.getBytes(Charsets.UTF8));
        return (int)crc32.getValue();
    }

    public static int crc32(String input, Charset charset) {
        CRC32 crc32 = new CRC32();
        crc32.update(input.getBytes(charset));
        return (int)crc32.getValue();
    }

    public static long crc32AsLong(byte[] input) {
        CRC32 crc32 = new CRC32();
        crc32.update(input);
        return crc32.getValue();
    }

    public static long crc32AsLong(String input) {
        CRC32 crc32 = new CRC32();
        crc32.update(input.getBytes(Charsets.UTF8));
        return crc32.getValue();
    }

    public static long crc32AsLong(String input, Charset charset) {
        CRC32 crc32 = new CRC32();
        crc32.update(input.getBytes(charset));
        return crc32.getValue();
    }

    public static int murmur32(byte[] input) {
        return Hashing.murmur3_32().hashBytes(input).asInt();
    }

    public static int murmur32(String input) {
        return Hashing.murmur3_32().hashString((CharSequence)input, Charsets.UTF8).asInt();
    }

    public static int murmur32(String input, Charset charset) {
        return Hashing.murmur3_32().hashString((CharSequence)input, charset).asInt();
    }

    public static int murmur32(byte[] input, int seed) {
        return Hashing.murmur3_32((int)seed).hashBytes(input).asInt();
    }

    public static int murmur32(String input, int seed) {
        return Hashing.murmur3_32((int)seed).hashString((CharSequence)input, Charsets.UTF8).asInt();
    }

    public static int murmur32(String input, Charset charset, int seed) {
        return Hashing.murmur3_32((int)seed).hashString((CharSequence)input, charset).asInt();
    }
}

