/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.nlp.common.util.thread;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolBuilder {
    private static RejectedExecutionHandler defaultRejectHandler = new ThreadPoolExecutor.AbortPolicy();

    public static class ConfigurableThreadPoolBuilder {
        private int minSize = 0;
        private int maxSize = Integer.MAX_VALUE;
        private int queueSize = 0;
        private int keepAliveSecs = 60;
        private ThreadFactory threadFactory = null;
        private RejectedExecutionHandler rejectHandler;

        public ConfigurableThreadPoolBuilder setMinSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public ConfigurableThreadPoolBuilder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public ConfigurableThreadPoolBuilder setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public ConfigurableThreadPoolBuilder setKeepAliveSecs(int keepAliveSecs) {
            this.keepAliveSecs = keepAliveSecs;
            return this;
        }

        public ConfigurableThreadPoolBuilder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ConfigurableThreadPoolBuilder setRejectHanlder(RejectedExecutionHandler rejectHandler) {
            this.rejectHandler = rejectHandler;
            return this;
        }

        public ExecutorService build() {
            AbstractQueue queue = null;
            queue = this.queueSize == 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.queueSize);
            if (this.threadFactory == null) {
                this.threadFactory = Executors.defaultThreadFactory();
            }
            if (this.rejectHandler == null) {
                this.rejectHandler = defaultRejectHandler;
            }
            return new ThreadPoolExecutor(this.minSize, this.maxSize, this.keepAliveSecs, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue), this.threadFactory, this.rejectHandler);
        }
    }

    public static class CachedThreadPoolBuilder {
        private int minSize = 0;
        private int maxSize = Integer.MAX_VALUE;
        private int keepAliveSecs = 60;
        private ThreadFactory threadFactory = null;
        private RejectedExecutionHandler rejectHandler;

        public CachedThreadPoolBuilder setMinSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public CachedThreadPoolBuilder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public CachedThreadPoolBuilder setKeepAliveSecs(int keepAliveSecs) {
            this.keepAliveSecs = keepAliveSecs;
            return this;
        }

        public CachedThreadPoolBuilder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public CachedThreadPoolBuilder setRejectHanlder(RejectedExecutionHandler rejectHandler) {
            this.rejectHandler = rejectHandler;
            return this;
        }

        public ExecutorService build() {
            if (this.threadFactory == null) {
                this.threadFactory = Executors.defaultThreadFactory();
            }
            if (this.rejectHandler == null) {
                this.rejectHandler = defaultRejectHandler;
            }
            return new ThreadPoolExecutor(this.minSize, this.maxSize, this.keepAliveSecs, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory, this.rejectHandler);
        }
    }

    public static class FixedThreadPoolBuilder {
        private int poolSize = 0;
        private int queueSize = 0;
        private ThreadFactory threadFactory = null;
        private RejectedExecutionHandler rejectHandler;

        public FixedThreadPoolBuilder setPoolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public FixedThreadPoolBuilder setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public FixedThreadPoolBuilder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public FixedThreadPoolBuilder setRejectHanlder(RejectedExecutionHandler rejectHandler) {
            this.rejectHandler = rejectHandler;
            return this;
        }

        public ExecutorService build() {
            if (this.poolSize < 1) {
                throw new IllegalArgumentException("size not set");
            }
            AbstractQueue queue = null;
            queue = this.queueSize == 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.queueSize);
            if (this.threadFactory == null) {
                this.threadFactory = Executors.defaultThreadFactory();
            }
            if (this.rejectHandler == null) {
                this.rejectHandler = defaultRejectHandler;
            }
            return new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), this.threadFactory, this.rejectHandler);
        }
    }
}

