/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html.impl;

import java.io.IOException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    private static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    private final DOMResult result;
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;

    public DOMBuilder() throws IOException {
        try {
            TransformerHandler handler = FACTORY.newTransformerHandler();
            this.contentHandler = handler;
            this.lexicalHandler = handler;
            this.result = new DOMResult();
            handler.setResult(this.result);
        }
        catch (TransformerException local) {
            throw (IOException)new IOException("Fatal-Error: Unable to get transformer handler").initCause(local);
        }
    }

    public Document getDocument() {
        if (this.result.getNode() == null) {
            return null;
        }
        if (this.result.getNode().getNodeType() == 9) {
            return (Document)this.result.getNode();
        }
        return this.result.getNode().getOwnerDocument();
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.contentHandler.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.contentHandler.endElement(uri, loc, raw);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.contentHandler.characters(c, start, len);
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.contentHandler.ignorableWhitespace(c, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.lexicalHandler.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this.lexicalHandler.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.lexicalHandler.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.lexicalHandler.comment(ch, start, len);
    }
}

