/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.tmptask.crawlOpenhub;

import com.bfd.crawler.kafka7.KfkProducer;
import com.bfd.crawler.tmptask.Constants;
import com.bfd.crawler.tmptask.ParserFactory;
import com.bfd.crawler.tmptask.Task;
import com.bfd.crawler.tmptask.workqueue.IWorkQueue;
import com.bfd.crawler.tmptask.workqueue.WorkQueueRAM;
import com.bfd.crawler.utils.JsonUtils;
import com.bfd.crawler.utils.ThreadUtils;
import com.bfd.crawler.utils.crawler.httpclient43.crawler.httpclient.Crawl4HttpClient;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class CrawlOpenhub
implements Runnable {
    private static AtomicInteger urlNum = new AtomicInteger(0);
    private static Logger log = Logger.getLogger(CrawlOpenhub.class);
    private static IWorkQueue queue = new WorkQueueRAM();
    String cid;

    public CrawlOpenhub(String cid) {
        this.cid = cid;
    }

    @Override
    public void run() {
        String url = "";
        String html = "";
        long interval = Constants.requestTimes;
        while (true) {
            try {
                while (true) {
                    log.info((Object)("workqueue size is " + queue.getQueueSize()));
                    Task task = WorkQueueRAM.queue.take();
                    url = task.getUrl();
                    log.info((Object)(ThreadUtils.getCurrentThreadName() + " start crawl url\uff1a" + url));
                    html = Crawl4HttpClient.getHtmlByDefaultHeader(task.getUrl())[0];
                    if (html == null || html.trim().length() == 0) continue;
                    log.info((Object)("url:" + url + "," + html));
                    HashMap<String, Object> parseRs = new HashMap<String, Object>();
                    ParserFactory.getParser(this.cid + "|" + task.getType()).parseHtml(html, task, parseRs);
                    parseRs.put("projectName", task.getCid());
                    parseRs.put("url", task.getUrl());
                    log.info((Object)("url:" + url + " parse rs :" + JsonUtils.toJSONString(parseRs)));
                    KfkProducer.getInstance().send("openhub_project_supplement", JsonUtils.toJSONString(parseRs));
                    urlNum.getAndIncrement();
                    log.info((Object)(urlNum.get() + " task over"));
                    Thread.currentThread();
                    Thread.sleep(interval);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)(ThreadUtils.getCurrentThreadName() + " err url is " + url), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        String url = "https://www.openhub.net/p/acetaociao";
        String html = Crawl4HttpClient.getHtmlByDefaultHeader(url)[0];
        HashMap parseRs = new HashMap();
    }
}

