/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import com.bfd.crawler.utils.JacksonMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.ObjectMapper;

public class JacksonUtils {
    public static <T> List<T> extractList(String listString, List<T> list) {
        if (listString == null) {
            return list;
        }
        ObjectMapper mapper = JacksonMapper.getInstance();
        try {
            list = (List)mapper.readValue(listString, list.getClass());
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> String compressObject(T object) {
        String json = "";
        ObjectMapper mapper = JacksonMapper.getInstance();
        try {
            json = mapper.writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static <T> T extractObject(String json, Class<T> valueType) {
        if (json == null || json.equals("")) {
            return null;
        }
        Object output = null;
        ObjectMapper mapper = JacksonMapper.getInstance();
        try {
            output = mapper.readValue(json, valueType);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)output;
    }

    public static <T> String compressList(List<T> list) {
        String listString = "";
        ObjectMapper mapper = JacksonMapper.getInstance();
        try {
            listString = mapper.writeValueAsString(list);
        }
        catch (JsonGenerationException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return listString;
    }

    public static <T, S> Map<T, S> extractMap(String mapString, Map<T, S> map) {
        if (mapString == null) {
            return map;
        }
        ObjectMapper mapper = JacksonMapper.getInstance();
        try {
            map = (Map)mapper.readValue(mapString, map.getClass());
        }
        catch (JsonParseException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }

    public static <T, S> String compressMap(Map<T, S> map) {
        String mapString = "";
        ObjectMapper mapper = JacksonMapper.getInstance();
        try {
            mapString = mapper.writeValueAsString(map);
        }
        catch (JsonGenerationException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mapString;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("html_content", "input");
        map.put("css_content", "textarea");
        String output = JacksonUtils.compressMap(map);
        System.out.println(output);
    }
}

