/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import com.bfd.crawler.utils.DataUtil;
import com.bfd.crawler.utils.EncodeUtil;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StringUtil {
    private static Logger log = Logger.getLogger(StringUtil.class);

    public static boolean hasValue(String str) {
        return str != null && !str.trim().equals("");
    }

    public static String getRegexGroup(String regex, String str, int id) {
        Pattern p;
        Matcher m;
        String resultStr = "";
        if (StringUtil.hasValue(str) && (m = (p = Pattern.compile(regex)).matcher(str)).find()) {
            resultStr = m.group(id);
        }
        if (resultStr.equals("")) {
            // empty if block
        }
        return resultStr;
    }

    public static String removeAllHtmlTags(String str) {
        if (StringUtil.hasValue(str)) {
            return str.replaceAll("<[^<>]+?>", "");
        }
        return "";
    }

    public static String getRegexGroup(Pattern regex, String str, int id) {
        Matcher m;
        String resultStr = "";
        if (StringUtil.hasValue(str) && (m = regex.matcher(str)).find()) {
            resultStr = m.group(id);
        }
        if (resultStr.equals("")) {
            log.error((Object)(regex + " parser error!"));
        }
        return resultStr;
    }

    public static String unzipPageAndGuessEncode(String compressHtml, String url) {
        byte[] data;
        try {
            data = DataUtil.unzipAndDecode(compressHtml);
        }
        catch (Exception e) {
            log.warn((Object)(Thread.currentThread().getName() + " unzip and Decode data Exception, Err:"), (Throwable)e);
            return "";
        }
        String dftCharset = "UTF8";
        String charset = EncodeUtil.getHtmlEncode(data, dftCharset);
        if (charset.equalsIgnoreCase("GB18030")) {
            log.warn((Object)("Guess page encode = GB18030\uff0c url=" + url));
        }
        log.info((Object)(Thread.currentThread().getName() + " guess encode=" + charset + ", url=" + url));
        String page = "";
        try {
            page = new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)(Thread.currentThread().getName() + " new page data string Exception, Err:"), (Throwable)e);
            return "";
        }
        return page;
    }

    public static String loadConvert(String str) {
        if (!StringUtil.hasValue(str)) {
            return "";
        }
        char[] in = str.toCharArray();
        int off = 0;
        char[] convtBuf = new char[0];
        int len = str.length();
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static void main(String[] args) throws Exception {
        String ssss = "public c";
        System.out.println(StringUtil.loadConvert(ssss));
    }
}

