/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.crawler.httpclient43.crawler.httpclient;

import com.bfd.crawler.utils.crawler.httpclient43.manager.crawler.HttpClientPojoManager;
import com.bfd.crawler.utils.crawler.httpclient43.pojos.HttpRequestPojo;
import com.bfd.crawler.utils.crawler.httpclient43.pojos.enumeration.HttpRequestMethod;
import com.bfd.crawler.utils.crawler.httpclient43.utils.LoginConfigUtil;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;

public class Crawl4HttpClient {
    public static String charSet = "utf-8";
    public static String USER_AGENT = "\tMozilla/5.0 (Windows NT 6.1; WOW64; rv:30.0) Gecko/20100101 Firefox/30.0";
    public static String ACCEPT_LANG = "\tzh-cn,en-us;q=0.8,zh-tw;q=0.5,en;q=0.3";
    public static String ACCEPT_CHARSET = "utf-8, GBK, GB2312;q=0.7,*;q=0.7";
    public static boolean proxy_open = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] crawlWebPage(HttpRequestPojo requestPojo) {
        CloseableHttpResponse response = null;
        try {
            RequestBuilder rb = null;
            rb = requestPojo.isGetMethod() ? RequestBuilder.get().setUri(URI.create(requestPojo.getUrl())) : RequestBuilder.post().setUri(new URI(requestPojo.getUrl()));
            Map<String, Object> map = null;
            map = requestPojo.getHeaderMap();
            if (map != null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    rb.addHeader(entry.getKey(), entry.getValue().toString());
                }
            }
            if ((map = requestPojo.getParasMap()) != null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    rb.addParameter(entry.getKey(), entry.getValue().toString());
                }
            }
            if (requestPojo.getFormEntity() != null) {
                rb.setEntity((HttpEntity)requestPojo.getFormEntity());
            }
            HttpUriRequest requestAll = null;
            HttpClientPojoManager.HttpClientPojo httpClientPojo = HttpClientPojoManager.getHttpClientPojo();
            if ("1".equals(LoginConfigUtil.getValueByKey("proxy_open"))) {
                rb.setConfig(httpClientPojo.getRequestConfig());
                requestAll = rb.build();
                System.out.println(httpClientPojo.getProxyPojo());
                response = httpClientPojo.getHttpClient().execute(requestAll);
            } else {
                rb.setConfig(HttpClientPojoManager.default_requestConfig);
                requestAll = rb.build();
                response = httpClientPojo.getHttpClient().execute(requestAll);
            }
            HttpEntity entity = response.getEntity();
            String content = Crawl4HttpClient.getContent(entity);
            String cookieStr = Crawl4HttpClient.getCookie((HttpResponse)response);
            String[] rs = new String[]{content, cookieStr};
            String[] stringArray = rs;
            return stringArray;
        }
        catch (SocketTimeoutException timeOutException) {
            timeOutException.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String getCookie(HttpResponse response) {
        String cookies = "";
        String temp = "";
        int count = 1;
        Header[] h = response.getAllHeaders();
        for (int i = 0; i < h.length; ++i) {
            if (!h[i].getName().contains("Set-Cookie")) continue;
            temp = h[i].getValue();
            cookies = count == 1 ? cookies + temp : cookies + ";" + temp;
            ++count;
        }
        return cookies;
    }

    private static String getContent(HttpEntity entity) throws Exception {
        if (entity == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = EntityUtils.toByteArray((HttpEntity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        charSet = EntityUtils.getContentCharSet((HttpEntity)entity);
        entity.consumeContent();
        if (charSet == null || charSet.trim().equals("") || charSet.trim().equals("none")) {
            String regEx = null;
            regEx = "<(meta|\\?\\s?xml).*?(charset=|encoding=)\"?([\\w-]+)";
            Pattern p = Pattern.compile(regEx, 2);
            Matcher m = p.matcher(new String(bytes));
            charSet = m.find() && m.groupCount() == 3 ? m.group(3) : "utf-8";
        }
        if (charSet != null && charSet != "") {
            return new String(bytes, charSet);
        }
        return new String(bytes);
    }

    private static Map<String, Object> getDefaultHeader() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("User-Agent", USER_AGENT);
        headers.put("Cookie", "uid=rB0lMlUtJOk2wS3tA0/ZAg==; _ga=GA1.2.1626696447.1429021860; _ohloh_session=BAh7BzoPc2Vzc2lvbl9pZEkiJWFhY2QzZTg5ZDg1MGQzNzM1MWIwYzY3MTFiMmIyYzEwBjoGRUY6DnJldHVybl90byIfL3AvYXBhY2hlLWNvbW1vbnMtbGF1bmNoZXI%3D--50857d280c3befaec576da870dfd7ee6bfb1eded; __atuvc=5%7C15; __atuvs=552ddcf0e14859ea003");
        return headers;
    }

    public static String[] getHtmlByDefaultHeader(String url) {
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        HttpRequestPojo requestPojo = new HttpRequestPojo();
        requestPojo.setRequestMethod(HttpRequestMethod.GET);
        Map<String, Object> headerMap = Crawl4HttpClient.getDefaultHeader();
        HashMap<String, Object> parasMap = new HashMap<String, Object>();
        requestPojo.setUrl(url);
        requestPojo.setHeaderMap(headerMap);
        requestPojo.setParasMap(parasMap);
        return Crawl4HttpClient.crawlWebPage(requestPojo);
    }

    public static void main2(String[] args) throws Exception {
        HttpRequestPojo requestPojo = new HttpRequestPojo();
        requestPojo.setRequestMethod(HttpRequestMethod.GET);
        String url = "http://www.baidu.com";
        System.out.println(args.length);
        String cookie = "";
        if (args.length == 1) {
            url = "http://s.weibo.com/wb/%25E5%258D%258E%25E4%25B8%25BA%25E8%258D%25A3%25E8%2580%2580&xsort=time";
            cookie = args[0];
        } else if (args.length == 2) {
            url = args[0];
            cookie = args[1];
        } else {
            System.out.println("params error!");
        }
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        HashMap<String, Object> parasMap = new HashMap<String, Object>();
        headerMap.put("Cookie", cookie);
        requestPojo.setUrl(url);
        requestPojo.setHeaderMap(headerMap);
        requestPojo.setParasMap(parasMap);
        String source = Crawl4HttpClient.crawlWebPage(requestPojo)[0];
        System.out.println(source);
        System.out.println("done!");
    }

    public static void main(String[] args) {
        String url = "https://www.openhub.net/p/acetaociao";
        String html = Crawl4HttpClient.getHtmlByDefaultHeader(url)[0];
        System.out.println(html);
    }
}

