/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.jdbc;

import com.bfd.crawler.utils.DataHelper;
import com.bfd.crawler.utils.JsonUtils;
import com.bfd.crawler.utils.jdbc.DBConnectionManager;
import com.bfd.crawler.utils.jdbc.DBInstance;
import com.bfd.crawler.utils.jdbc.DBServer;
import com.bfd.crawler.utils.jdbc.Route;
import com.bfd.crawler.utils.zookeeper.ZKCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DBShardingManager {
    public static final Log LOG = LogFactory.getLog(DBShardingManager.class);
    private static final String DB_CONFIG_FILE = "../etc/dbconfig.xml";
    private Map<String, String> drivers = new HashMap<String, String>();
    private static DBShardingManager instance = new DBShardingManager();
    private Map<String, DBInstance> dbInstances;
    private Map<String, DBServer> dbServers;
    private Map<String, Integer> shardingTableSize;

    public static DBShardingManager getInstance() {
        return instance;
    }

    private DBShardingManager() {
        this.init();
    }

    private void init() {
        if (this.dbInstances == null) {
            this.dbInstances = new HashMap<String, DBInstance>();
        }
        if (this.dbServers == null) {
            this.dbServers = new HashMap<String, DBServer>();
        }
        if (this.shardingTableSize == null) {
            this.shardingTableSize = new HashMap<String, Integer>();
        }
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document load(String file) {
        System.out.print(System.getProperty("user.dir"));
        InputStream stream = DBShardingManager.class.getClassLoader().getResourceAsStream(file);
        if (stream == null) {
            try {
                File f = new File(file);
                if (f.exists()) {
                    stream = new FileInputStream(f);
                }
            }
            catch (SecurityException e) {
                LOG.error((Object)"security manager may forbid access to the local file system", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)(file + " not found"), (Throwable)e);
            }
        }
        try {
            Document e = Jsoup.parse((InputStream)stream, (String)"utf8", (String)file);
            return e;
        }
        catch (Exception e) {
            LOG.error((Object)("read " + file + " error"), (Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)("read " + file + " error"), (Throwable)e);
            }
            stream = null;
            file = null;
        }
        return null;
    }

    private void loadDbServers(Map<String, Object> map) {
        List list = (List)map.get("db");
        if (list == null || list.size() == 0) {
            throw new RuntimeException("single instance should has child node of server, but there is no server nodes");
        }
        for (int i = 0; i < list.size(); ++i) {
            Map dbElem = (Map)list.get(i);
            DBServer dbServer = new DBServer();
            String name = (String)dbElem.get("name");
            String host = (String)dbElem.get("host");
            String port = (String)dbElem.get("port");
            String charset = (String)dbElem.get("charset");
            String user = (String)dbElem.get("user");
            String password = (String)dbElem.get("password");
            String dbtype = (String)dbElem.get("dbtype");
            String database = (String)dbElem.get("database");
            String maxconn = (String)dbElem.get("maxconn");
            if (StringUtils.isEmpty((String)host) || StringUtils.isEmpty((String)port) || StringUtils.isEmpty((String)charset) || StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)dbtype) || StringUtils.isEmpty((String)database) || StringUtils.isEmpty((String)maxconn)) {
                throw new RuntimeException("single server config param is invalid. some fields are empty");
            }
            dbServer.setHost(host);
            dbServer.setPort(port);
            dbServer.setCharset(charset);
            dbServer.setUser(user);
            dbServer.setPassword(password);
            dbServer.setDbtype(dbtype);
            dbServer.setDatabase(database);
            dbServer.setMaxConn(Integer.parseInt(maxconn));
            dbServer.setName(name);
            this.dbServers.put(name, dbServer);
        }
    }

    private void loadConfig() {
        Map<String, Object> map = ZKCache.getDBConfigMap();
        if (map == null) {
            throw new RuntimeException("load db config error!");
        }
        List list = (List)map.get("driver");
        if (list == null || list.size() == 0) {
            throw new RuntimeException("<driver/> config is empty, please config right driver");
        }
        for (int i = 0; i < list.size(); ++i) {
            Map elem = (Map)list.get(i);
            this.drivers.put((String)elem.get("dbtype"), (String)elem.get("value"));
        }
        this.loadDbServers(map);
        List list2 = (List)map.get("instance");
        for (int i = 0; i < list2.size(); ++i) {
            List routeElems;
            DBInstance dbInstance = new DBInstance();
            Map instanceElem = (Map)list2.get(i);
            String name = instanceElem.get("name").toString();
            dbInstance.setName(name);
            String type = instanceElem.get("type").toString();
            dbInstance.setType(type);
            if (!type.equalsIgnoreCase("single")) {
                if (type.equalsIgnoreCase("router")) {
                    String table = instanceElem.get("table").toString();
                    String tSize = instanceElem.get("tablesize").toString();
                    if (StringUtils.isEmpty((String)table) || StringUtils.isEmpty((String)tSize)) {
                        throw new RuntimeException("<instance type=router> 's param is invalid. table or size is empty.");
                    }
                    if (!StringUtils.isNumeric((String)tSize)) {
                        throw new RuntimeException("<instance type=router> 's param is invalid. size is not numeric.");
                    }
                    int size = Integer.parseInt(tSize);
                    dbInstance.setTable(table);
                    dbInstance.setSize(size);
                    this.shardingTableSize.put(table, size);
                } else {
                    throw new RuntimeException("invalid instance type. type should be 'router' or 'singler', but the type is " + type);
                }
            }
            if ((routeElems = (List)instanceElem.get("route")) == null || routeElems.size() == 0) {
                throw new RuntimeException("<instance type=router> 's config param is invalid. route field can not be empty");
            }
            ArrayList<Route> routes = new ArrayList<Route>();
            for (int j = 0; j < routeElems.size(); ++j) {
                Route route = new Route();
                Map routeElem = (Map)routeElems.get(j);
                String db = (String)routeElem.get("db");
                DBServer dbServer = this.dbServers.get(db);
                if (dbServer == null) {
                    throw new RuntimeException("<route> param is invalid. index or db is empty,  or size is not numeric");
                }
                route.setDbName(db);
                route.setDbServer(dbServer);
                if (StringUtils.isEmpty((String)db)) {
                    throw new RuntimeException("<route> param is invalid. db is empty");
                }
                if ("router".equalsIgnoreCase(type)) {
                    String index = (String)routeElem.get("index");
                    if (StringUtils.isEmpty((String)index) || !StringUtils.isNumeric((String)index)) {
                        throw new RuntimeException("<route> param is invalid. index is empty,  or is not numeric, index=" + index);
                    }
                    route.setIndex(Integer.parseInt(index));
                }
                routes.add(route);
            }
            Collections.sort(routes);
            dbInstance.setRoutes(routes);
            this.dbInstances.put(name, dbInstance);
        }
        LOG.info((Object)"success to load dbconfig in DBShardingManager from zk...");
        LOG.info((Object)("load and cache dbInstanceMap successfully, dbInstanceMap ->" + JsonUtils.toJSONString(this.dbInstances)));
        LOG.info((Object)("load and cache shardingTableSize successfully, shardingTableSize ->" + JsonUtils.toJSONString(this.shardingTableSize)));
    }

    private void loadDbServers(Document doc) {
        Elements dbElems = doc.select("db");
        if (dbElems == null || dbElems.size() == 0) {
            throw new RuntimeException("single instance should has child node of server, but there is no server nodes");
        }
        for (int i = 0; i < dbElems.size(); ++i) {
            Element dbElem = dbElems.get(i);
            DBServer dbServer = new DBServer();
            String name = dbElem.attr("name");
            String host = dbElem.attr("host");
            String port = dbElem.attr("port");
            String charset = dbElem.attr("charset");
            String user = dbElem.attr("user");
            String password = dbElem.attr("password");
            String dbtype = dbElem.attr("dbtype");
            String database = dbElem.attr("database");
            String maxconn = dbElem.attr("maxconn");
            if (StringUtils.isEmpty((String)host) || StringUtils.isEmpty((String)port) || StringUtils.isEmpty((String)charset) || StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)dbtype) || StringUtils.isEmpty((String)database) || StringUtils.isEmpty((String)maxconn)) {
                throw new RuntimeException("single server config param is invalid. some fields are empty");
            }
            dbServer.setHost(host);
            dbServer.setPort(port);
            dbServer.setCharset(charset);
            dbServer.setUser(user);
            dbServer.setPassword(password);
            dbServer.setDbtype(dbtype);
            dbServer.setDatabase(database);
            dbServer.setMaxConn(Integer.parseInt(maxconn));
            dbServer.setName(name);
            this.dbServers.put(name, dbServer);
        }
    }

    public Map<String, DBInstance> getBbInstanceMap() {
        if (this.dbInstances == null || this.dbInstances.size() == 0) {
            this.loadConfig();
        }
        return this.dbInstances;
    }

    private void initAllConnManagers() {
        Map<String, DBInstance> instances = this.getBbInstanceMap();
        for (Map.Entry<String, DBInstance> entry : instances.entrySet()) {
            DBConnectionManager manager;
            DBInstance dbInstance = entry.getValue();
            DBServer server = dbInstance.getServer();
            if (server == null || (manager = this.getConnManager(server)) != null) continue;
            LOG.warn((Object)("dbconnection manager is null, dbConfig -> " + dbInstance));
        }
    }

    public DBConnectionManager getConnManager(DBServer server) {
        if (server == null) {
            throw new RuntimeException("param exception, server is null");
        }
        DBConnectionManager manager = DBConnectionManager.getInstance();
        if (manager.hasInitialized(server.getName())) {
            return manager;
        }
        manager.setDBDrivers(this.drivers.get(server.getDbtype()));
        String url = "jdbc:" + server.getDbtype() + "://" + server.getHost() + ":" + server.getPort() + "/" + server.getDatabase() + "?characterEncoding=" + server.getCharset();
        manager.setDBParams(server.getName(), url, server.getUser(), server.getPassword(), server.getMaxConn());
        LOG.info((Object)("initlized dbconnection pool, url -> " + url));
        return manager;
    }

    private int hash(String bizStr, int size) {
        String md5 = DataHelper.calcMD5(bizStr.toLowerCase());
        String head = md5.substring(0, 8);
        return (int)(Long.parseLong(head, 16) % (long)size);
    }

    public Connection getConnection(DBServer server) {
        Connection conn = this.getConnManager(server).getConnection(server.getName());
        while (conn == null) {
            LOG.warn((Object)(" get db connection failed, dbserver -> " + server));
            DBShardingManager.sleep(2);
            conn = this.getConnManager(server).getConnection(server.getName());
        }
        return conn;
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException e) {
            System.out.println("sleep(int),errormsg=" + e.getMessage());
        }
    }

    private int getTableShardingSize(String tableName) {
        return this.shardingTableSize.get(tableName);
    }

    public void freeConnection(DBServer dbServer, Connection conn) {
        this.getConnManager(dbServer).freeConnection(dbServer.getName(), conn);
    }

    public Connection getConnection(String conName, int tableIndex) {
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance.getType().equalsIgnoreCase("router")) {
            int size = dbInstance.getSize();
            if (tableIndex >= size) {
                throw new RuntimeException("table index out of bound, table sharding size is" + size + ", but table_index=" + tableIndex);
            }
            int dbIndex = tableIndex % dbInstance.getRoutes().size();
            Route route = dbInstance.getRoutes().get(dbIndex);
            return this.getConnection(route.getDbServer());
        }
        throw new RuntimeException("Error, the biz conName is not a sharding database, conName -> " + conName);
    }

    public Connection getConnection(String conName, String bizStr) {
        if (StringUtils.isEmpty((String)bizStr)) {
            throw new RuntimeException("there is none dbInstance named by " + conName);
        }
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance == null) {
            throw new RuntimeException("there is none dbInstance named by " + conName);
        }
        if ("router".equalsIgnoreCase(dbInstance.getType())) {
            int dbIndex = this.hash(bizStr, dbInstance.getSize()) % dbInstance.getRoutes().size();
            Route route = dbInstance.getRoutes().get(dbIndex);
            return this.getConnection(route.getDbServer());
        }
        throw new RuntimeException("Exception, the biz conName is not a sharding database, conName -> " + conName);
    }

    public Connection getConnection(String conName) {
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance == null) {
            throw new RuntimeException("Exception, there is none dbinstance named by " + conName);
        }
        if ("router".equalsIgnoreCase(dbInstance.getType())) {
            throw new RuntimeException("Exception, the biz conName is a sharding database, another param ( bisstr, tableindex) is needed, conName -> " + conName);
        }
        return this.getConnection(dbInstance.getRoutes().get(0).getDbServer());
    }

    public int getShardingTableSize(String conName) {
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance == null) {
            throw new RuntimeException("Exception, there is none dbinstance named by " + conName);
        }
        return dbInstance.getSize();
    }

    public int getShardingDBSize(String conName) {
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance == null) {
            throw new RuntimeException("there is none dbinstance named by " + conName);
        }
        return dbInstance.getRoutes().size();
    }

    public void freeConnection(String conName, int tableIndex, Connection conn) {
        DBInstance instance = this.dbInstances.get(conName);
        if (instance == null) {
            throw new RuntimeException("Exception, there is none dbinstance named by " + conName);
        }
        if ("router".equalsIgnoreCase(instance.getType())) {
            int dbIndex = tableIndex % instance.getRoutes().size();
            Route route = instance.getRoutes().get(dbIndex);
            this.freeConnection(route.getDbServer(), conn);
            return;
        }
        throw new RuntimeException("Exception, the biz conName is not a sharding database, conName -> " + conName);
    }

    public void freeConnection(String conName, String str, Connection conn) {
        DBInstance instance = this.dbInstances.get(conName);
        if (instance == null) {
            throw new RuntimeException("there is none dbinstance named by " + conName);
        }
        if ("router".equalsIgnoreCase(instance.getType())) {
            int tableIndex = this.hash(str, instance.getSize());
            int dbIndex = tableIndex % instance.getRoutes().size();
            Route route = instance.getRoutes().get(dbIndex);
            this.freeConnection(route.getDbServer(), conn);
            return;
        }
        throw new RuntimeException("Exception, the biz conName is not a sharding database, conName -> " + conName);
    }

    public void freeConnection(String conName, Connection conn) {
        DBInstance instance = this.dbInstances.get(conName);
        if ("router".equalsIgnoreCase(instance.getType())) {
            throw new RuntimeException("Exception, the biz conName is a sharding database, another param ( bisstr, tableindex) is needed, conName -> " + conName);
        }
        Route route = instance.getRoutes().get(0);
        this.freeConnection(route.getDbServer(), conn);
    }

    public String getTableName(String table, int tableIndex) {
        StringBuilder tableName = new StringBuilder().append(table).append("_");
        int size = this.getTableShardingSize(table);
        if (tableIndex >= size) {
            throw new RuntimeException("table index out of bound, sharding_size=" + size + ", but table_index=" + tableIndex);
        }
        return tableName.append(this.replenishSuffixWith0(size, tableIndex)).append(tableIndex).toString();
    }

    public String getTableName(String table, String bizStr) {
        StringBuilder tableName = new StringBuilder().append(table).append("_");
        int size = this.getTableShardingSize(table);
        int tableIndex = this.hash(bizStr, size);
        return tableName.append(this.replenishSuffixWith0(size, tableIndex)).append(tableIndex).toString();
    }

    private String replenishSuffixWith0(int size, int tableIndex) {
        if (tableIndex < 10) {
            return "00";
        }
        if (tableIndex < 100) {
            return "0";
        }
        return "";
    }

    public static void main(String[] args) throws SQLException {
        PropertyConfigurator.configure((String)"/home/ian/dev/crawldispatch/conf/log4j.properties");
        String cid = "Cdida";
        String url = "http://wuxi.didatuan.com/q-\u4fdd\u517b";
        String bizStr = cid + "_" + url;
        Connection conn = DBShardingManager.getInstance().getConnection("task_list", bizStr);
        String table = DBShardingManager.getInstance().getTableName("itemlist", bizStr);
        System.out.println(table);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from " + table + " where listurl='" + url + "'");
        if (rs.next()) {
            System.out.println(rs.getInt("rid"));
        }
        DBShardingManager.getInstance().freeConnection("task_list", bizStr, conn);
        System.out.println("ss");
    }
}

