/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.templateparser;

import com.bfd.crawler.utils.templateparser.DomCFGElement;
import com.bfd.crawler.utils.templateparser.DomCFGField;
import com.bfd.crawler.utils.templateparser.DomCFGTree;
import com.bfd.crawler.utils.templateparser.DomSearch;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class DomCFGBlock
extends DomCFGTree
implements DomCFGElement {
    private static final Log LOG = LogFactory.getLog(DomCFGBlock.class);
    private String[] path;
    private String name;
    private List<DomCFGField> fields;
    private List<DomCFGTree> children;
    private List<DomCFGBlock> blocks;
    private boolean isImglist = false;

    public DomCFGBlock(Node node) {
        String stmp;
        String mName = node.getNodeName();
        if (!"block".equalsIgnoreCase(mName)) {
            return;
        }
        this.fields = new ArrayList<DomCFGField>();
        this.children = new ArrayList<DomCFGTree>();
        this.blocks = new ArrayList<DomCFGBlock>();
        this.name = DomSearch.getNodeAttr(node, "name", "");
        if ("imglist".equalsIgnoreCase(this.name)) {
            this.isImglist = true;
        }
        if ((stmp = DomSearch.getNodeAttr(node, "path", "")).length() > 0) {
            this.path = stmp.split("/");
        }
        for (Node cld = node.getFirstChild(); cld != null; cld = cld.getNextSibling()) {
            String childName = cld.getNodeName();
            if ("node".equalsIgnoreCase(childName)) {
                this.children.add(new DomCFGTree(cld));
                continue;
            }
            if ("fld".equalsIgnoreCase(childName)) {
                this.fields.add(new DomCFGField(cld));
                continue;
            }
            if (!"block".equalsIgnoreCase(childName)) continue;
            this.blocks.add(new DomCFGBlock(cld));
        }
    }

    @Override
    public String[] getTreePath() {
        return this.path;
    }

    public void setTreePath(String[] treePath) {
        this.path = treePath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<DomCFGField> getFields() {
        return this.fields;
    }

    public void setFields(List<DomCFGField> field) {
        this.fields = field;
    }

    @Override
    public List<DomCFGBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<DomCFGBlock> blocks) {
        this.blocks = blocks;
    }

    @Override
    public List<DomCFGTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<DomCFGTree> child) {
        this.children = child;
    }

    public String[] getPath() {
        return this.path;
    }

    public void setPath(String[] path) {
        this.path = path;
    }

    public boolean isImglist() {
        return this.isImglist;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sbBuilder = new StringBuilder();
        if (this.path == null) {
            sbBuilder.append("No path");
        } else {
            for (i = 0; i < this.path.length; ++i) {
                if (i > 0) {
                    sbBuilder.append("/").append(this.path[i]);
                    continue;
                }
                sbBuilder.append("path=").append(this.path[i]);
            }
        }
        for (i = 0; i < this.fields.size(); ++i) {
            sbBuilder.append(",").append("field-").append(i).append(":").append(this.fields.get(i).toString());
        }
        for (i = 0; i < this.blocks.size(); ++i) {
        }
        for (i = 0; i < this.children.size(); ++i) {
        }
        sbBuilder.append(",").append("name=").append(this.name);
        return sbBuilder.toString();
    }
}

