/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.algorithm;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class AVLTree<E> {
    private Entry<E> root = null;
    private int size = 0;
    private static final int LH = 1;
    private static final int EH = 0;
    private static final int RH = -1;

    public int size() {
        return this.size;
    }

    private void rotateLeft(Entry<E> p) {
        System.out.println("\u7ed5" + p.element + "\u5de6\u65cb");
        if (p != null) {
            Entry r = p.right;
            p.right = r.left;
            if (r.left != null) {
                r.left.parent = p;
            }
            r.parent = p.parent;
            if (p.parent == null) {
                this.root = r;
            } else if (p.parent.left == p) {
                p.parent.left = r;
            } else {
                p.parent.right = r;
            }
            r.left = p;
            p.parent = r;
        }
    }

    private void rotateRight(Entry<E> p) {
        System.out.println("\u7ed5" + p.element + "\u53f3\u65cb");
        if (p != null) {
            Entry l = p.left;
            p.left = l.right;
            if (l.right != null) {
                l.right.parent = p;
            }
            l.parent = p.parent;
            if (p.parent == null) {
                this.root = l;
            } else if (p.parent.right == p) {
                p.parent.right = l;
            } else {
                p.parent.left = l;
            }
            l.right = p;
            p.parent = l;
        }
    }

    public boolean add(E element) {
        int cmp;
        Entry<E> parent;
        Entry<E> t2 = this.root;
        if (t2 == null) {
            this.root = new Entry<E>(element, null);
            this.size = 1;
            return true;
        }
        Comparable e = (Comparable)element;
        do {
            parent = t2;
            cmp = e.compareTo(t2.element);
            if (cmp < 0) {
                t2 = t2.left;
                continue;
            }
            if (cmp > 0) {
                t2 = t2.right;
                continue;
            }
            return false;
        } while (t2 != null);
        Entry<E> child = new Entry<E>(element, parent);
        if (cmp < 0) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        while (parent != null) {
            cmp = e.compareTo(parent.element);
            parent.balance = cmp < 0 ? ++parent.balance : --parent.balance;
            if (parent.balance == 0) break;
            if (Math.abs(parent.balance) == 2) {
                this.fixAfterInsertion(parent);
                break;
            }
            parent = parent.parent;
        }
        ++this.size;
        return true;
    }

    private void fixAfterInsertion(Entry<E> p) {
        if (p.balance == 2) {
            this.leftBalance(p);
        }
        if (p.balance == -2) {
            this.rightBalance(p);
        }
    }

    private boolean leftBalance(Entry<E> t2) {
        boolean heightLower = true;
        Entry l = t2.left;
        switch (l.balance) {
            case 1: {
                l.balance = 0;
                t2.balance = 0;
                this.rotateRight(t2);
                break;
            }
            case -1: {
                Entry rd = l.right;
                switch (rd.balance) {
                    case 1: {
                        t2.balance = -1;
                        l.balance = 0;
                        break;
                    }
                    case 0: {
                        l.balance = 0;
                        t2.balance = 0;
                        break;
                    }
                    case -1: {
                        t2.balance = 0;
                        l.balance = 1;
                    }
                }
                rd.balance = 0;
                this.rotateLeft(t2.left);
                this.rotateRight(t2);
                break;
            }
            case 0: {
                l.balance = -1;
                t2.balance = 1;
                this.rotateRight(t2);
                heightLower = false;
            }
        }
        return heightLower;
    }

    private boolean rightBalance(Entry<E> t2) {
        boolean heightLower = true;
        Entry r = t2.right;
        switch (r.balance) {
            case 1: {
                Entry ld = r.left;
                switch (ld.balance) {
                    case 1: {
                        t2.balance = 0;
                        r.balance = -1;
                        break;
                    }
                    case 0: {
                        r.balance = 0;
                        t2.balance = 0;
                        break;
                    }
                    case -1: {
                        t2.balance = 1;
                        r.balance = 0;
                    }
                }
                ld.balance = 0;
                this.rotateRight(t2.right);
                this.rotateLeft(t2);
                break;
            }
            case -1: {
                r.balance = 0;
                t2.balance = 0;
                this.rotateLeft(t2);
                break;
            }
            case 0: {
                r.balance = 1;
                t2.balance = -1;
                this.rotateLeft(t2);
                heightLower = false;
            }
        }
        return heightLower;
    }

    private Entry<E> getEntry(Object element) {
        Entry<E> tmp = this.root;
        Comparable e = (Comparable)element;
        while (tmp != null) {
            int c = e.compareTo(tmp.element);
            if (c == 0) {
                return tmp;
            }
            if (c < 0) {
                tmp = tmp.left;
                continue;
            }
            tmp = tmp.right;
        }
        return null;
    }

    public boolean remove(Object o) {
        Entry<E> e = this.getEntry(o);
        if (e != null) {
            this.deleteEntry(e);
            return true;
        }
        return false;
    }

    private void deleteEntry(Entry<E> p) {
        Entry replacement;
        --this.size;
        if (p.left != null && p.right != null) {
            Entry<E> s = AVLTree.successor(p);
            p.element = s.element;
            p = s;
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            this.fixAfterDeletion(replacement);
        } else if (p.parent == null) {
            this.root = null;
        } else {
            this.fixAfterDeletion(p);
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    static <E> Entry<E> successor(Entry<E> t2) {
        if (t2 == null) {
            return null;
        }
        if (t2.right != null) {
            Entry p = t2.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t2.parent;
        Entry<E> ch = t2;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private void fixAfterDeletion(Entry<E> p) {
        boolean heightLower = true;
        Entry t2 = p.parent;
        Comparable e = (Comparable)p.element;
        while (t2 != null && heightLower) {
            int cmp = e.compareTo(t2.element);
            t2.balance = cmp >= 0 ? ++t2.balance : --t2.balance;
            if (Math.abs(t2.balance) == 1) break;
            Entry r = t2;
            if (t2.balance == 2) {
                heightLower = this.leftBalance(r);
            } else if (t2.balance == -2) {
                heightLower = this.rightBalance(r);
            }
            t2 = t2.parent;
        }
    }

    public Iterator<E> itrator() {
        return new BinarySortIterator();
    }

    private int treeHeight(Entry<E> p) {
        if (p == null) {
            return -1;
        }
        return 1 + Math.max(this.treeHeight(p.left), this.treeHeight(p.right));
    }

    public static void main(String[] args) {
        AVLTree<Integer> tree = new AVLTree<Integer>();
        System.out.println("------\u6dfb\u52a0------");
        tree.add(50);
        System.out.print("50 ");
        tree.add(66);
        System.out.print("66 ");
        for (int i = 0; i < 10; ++i) {
            int ran = (int)(Math.random() * 100.0);
            System.out.print(ran + " ");
            tree.add(ran);
        }
        System.out.println("------\u5220\u9664------");
        tree.remove(50);
        tree.remove(66);
        System.out.println();
        Iterator it = tree.itrator();
        while (it.hasNext()) {
            System.out.print(it.next() + " ");
        }
    }

    private class BinarySortIterator
    implements Iterator<E> {
        Entry<E> next;
        Entry<E> lastReturned;

        public BinarySortIterator() {
            Entry s = AVLTree.this.root;
            if (s != null) {
                while (s.left != null) {
                    s = s.left;
                }
            }
            this.next = s;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = AVLTree.successor(e);
            this.lastReturned = e;
            return e.element;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            AVLTree.this.deleteEntry(this.lastReturned);
            this.lastReturned = null;
        }
    }

    static class Entry<E> {
        E element;
        Entry<E> parent;
        Entry<E> left;
        Entry<E> right;
        int balance = 0;

        public Entry(E element, Entry<E> parent) {
            this.element = element;
            this.parent = parent;
        }

        public Entry() {
        }

        public String toString() {
            return this.element + " BF=" + this.balance;
        }
    }
}

